/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderChildrenPair;
import org.openide.loaders.FolderList;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class FolderChildrenEager
extends Children.Keys<FolderChildrenPair>
implements PropertyChangeListener,
ChangeListener {
    private DataFolder folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private Logger err;
    private boolean refresh;
    private RequestProcessor.Task refreshTask;
    private ChildrenRefreshRunnable refreshRunnable;
    private static RequestProcessor refRP = new RequestProcessor("FolderChildren_Refresh");

    public FolderChildrenEager(DataFolder f) {
        this(f, DataFilter.ALL);
    }

    public FolderChildrenEager(DataFolder f, DataFilter filter) {
        this.folder = f;
        this.filter = filter;
        this.refreshRunnable = new ChildrenRefreshRunnable();
        this.refreshTask = refRP.create((Runnable)this.refreshRunnable);
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        String log = f.getPrimaryFile().isRoot() ? "org.openide.loaders.FolderChildren" : "org.openide.loaders.FolderChildren." + f.getPrimaryFile().getPath().replace('/', '.');
        this.err = Logger.getLogger(log);
    }

    DataFilter getFilter() {
        return this.filter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("children".equals(ev.getPropertyName())) {
            this.err.fine("Got PROP_CHILDREN");
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
        if ("sortMode".equals(ev.getPropertyName()) || "order".equals(ev.getPropertyName())) {
            this.err.fine("Got PROP_SORT_MODE or PROP_ORDER");
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh = true;
        this.refreshChildren().schedule(0);
        this.postClearTask();
    }

    private void postClearTask() {
        refRP.post(new Runnable(){

            @Override
            public void run() {
                FolderChildrenEager.this.refreshRunnable.clear();
            }
        });
    }

    RequestProcessor.Task refreshChildren() {
        return this.refreshTask;
    }

    protected Node[] createNodes(FolderChildrenPair key) {
        this.err.fine("createNodes: " + key);
        FileObject fo = key.primaryFile;
        try {
            DataObject obj = DataObject.find(fo);
            if (this.filter == null || this.filter.acceptDataObject(obj)) {
                return new Node[]{obj.getClonedNodeDelegate(this.filter)};
            }
            return new Node[0];
        }
        catch (DataObjectNotFoundException e) {
            Logger.getLogger(FolderChildrenEager.class.getName()).log(Level.FINE, null, e);
            return new Node[0];
        }
    }

    public Node[] getNodes(boolean optimalResult) {
        Node[] res;
        if (optimalResult) {
            if (FolderChildrenEager.checkChildrenMutex()) {
                this.err.fine("getNodes(true)");
                FolderList.find(this.folder.getPrimaryFile(), true).waitProcessingFinished();
                this.err.fine("getNodes(true): waitProcessingFinished");
                RequestProcessor.Task task = this.refreshChildren();
                res = this.getNodes();
                this.err.fine("getNodes(true): getNodes: " + res.length);
                task.schedule(0);
                task.waitFinished();
                this.err.fine("getNodes(true): waitFinished");
            } else {
                Logger.getLogger(FolderChildrenEager.class.getName()).log(Level.WARNING, null, new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
            }
        }
        res = this.getNodes();
        this.err.fine("getNodes(boolean): post clear task");
        this.postClearTask();
        return res;
    }

    public Node findChild(String name) {
        if (FolderChildrenEager.checkChildrenMutex()) {
            this.getNodes(true);
        }
        return super.findChild(name);
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        this.err.fine("addNotify begin");
        this.folder.addPropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).addChangeListener(this);
        }
        this.refreshChildren().schedule(0);
        this.err.fine("addNotify end");
    }

    protected void removeNotify() {
        this.err.fine("removeNotify begin");
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this);
        }
        this.setKeys(Collections.emptySet());
        this.err.fine("removeNotify end");
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    private final class ChildrenRefreshRunnable
    implements Runnable {
        private DataObject[] ch;

        private ChildrenRefreshRunnable() {
        }

        @Override
        public void run() {
            assert (refRP.isRequestProcessorThread());
            FolderList.find(FolderChildrenEager.this.folder.getPrimaryFile(), true).waitProcessingFinished();
            this.ch = FolderChildrenEager.this.folder.getChildren();
            FolderChildrenEager.this.err.fine("Children computed");
            FolderChildrenPair[] keys = new FolderChildrenPair[this.ch.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = new FolderChildrenPair(this.ch[i].getPrimaryFile());
            }
            FolderChildrenEager.this.setKeys(Arrays.asList(keys));
            if (FolderChildrenEager.this.refresh) {
                FolderChildrenEager.this.refresh = false;
                for (FolderChildrenPair key : keys) {
                    FolderChildrenEager.this.refreshKey(key);
                }
            }
            if (!FolderChildrenEager.this.isInitialized()) {
                this.clear();
            }
        }

        public void clear() {
            assert (refRP.isRequestProcessorThread());
            FolderChildrenEager.this.err.fine("Clearing the reference to children");
            this.ch = null;
        }
    }
}

