/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.LinkedList;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Task;

public interface UndoRedo {
    public static final UndoRedo NONE = new Empty();

    public boolean canUndo();

    public boolean canRedo();

    public void undo() throws CannotUndoException;

    public void redo() throws CannotRedoException;

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public String getUndoPresentationName();

    public String getRedoPresentationName();

    @Deprecated
    public static final class Empty
    implements UndoRedo {
        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public boolean canRedo() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            throw new CannotUndoException();
        }

        @Override
        public void redo() throws CannotRedoException {
            throw new CannotRedoException();
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public String getUndoPresentationName() {
            return "";
        }

        @Override
        public String getRedoPresentationName() {
            return "";
        }
    }

    public static class Manager
    extends UndoManager
    implements UndoRedo {
        static final long serialVersionUID = 6721367974521509720L;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private LinkedList<UndoableEditEvent> runus = new LinkedList();
        private Task task = Task.EMPTY;

        private void superUndoableEditHappened(UndoableEditEvent ue) {
            super.undoableEditHappened(ue);
        }

        private void superDiscardAllEdits() {
            super.discardAllEdits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undoableEditHappened(UndoableEditEvent ue) {
            LinkedList<UndoableEditEvent> linkedList = this.runus;
            synchronized (linkedList) {
                this.runus.add(ue);
            }
            this.updateTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discardAllEdits() {
            LinkedList<UndoableEditEvent> linkedList = this.runus;
            synchronized (linkedList) {
                this.runus.add(null);
            }
            this.updateTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canUndo() {
            boolean empty;
            LinkedList<UndoableEditEvent> linkedList = this.runus;
            synchronized (linkedList) {
                empty = this.runus.isEmpty();
            }
            if (!empty) {
                this.task.waitFinished();
            }
            return super.canUndo();
        }

        private void updateTask() {
            class R
            implements Runnable {
                R() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        UndoableEditEvent ue;
                        LinkedList linkedList = Manager.this.runus;
                        synchronized (linkedList) {
                            if (Manager.this.runus.isEmpty()) {
                                break;
                            }
                            ue = (UndoableEditEvent)Manager.this.runus.removeFirst();
                        }
                        if (ue == null) {
                            Manager.this.superDiscardAllEdits();
                        } else {
                            Manager.this.superUndoableEditHappened(ue);
                        }
                        Manager.this.cs.fireChange();
                    }
                }
            }
            R r = new R();
            r.run();
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public String getUndoPresentationName() {
            return this.canUndo() ? super.getUndoPresentationName() : "";
        }

        @Override
        public String getRedoPresentationName() {
            return this.canRedo() ? super.getRedoPresentationName() : "";
        }
    }
}

