/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import hidden.org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import java.io.File;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;

public class NBPluginParameterExpressionEvaluator
implements ExpressionEvaluator {
    private final PathTranslator pathTranslator = new DefaultPathTranslator();
    private final MavenProject project;
    private final String basedir;
    private final Properties properties;
    private Settings settings;

    public NBPluginParameterExpressionEvaluator(MavenProject project, Settings settings, Properties properties) {
        File projectFile;
        this.properties = properties;
        this.project = project;
        this.settings = settings;
        String bsdir = null;
        if (project != null && (projectFile = project.getBasedir()) != null) {
            bsdir = projectFile.getAbsolutePath();
        }
        if (bsdir == null) {
            bsdir = System.getProperty("user.dir");
        }
        this.basedir = bsdir;
    }

    public Object evaluate(String expr) throws ExpressionEvaluationException {
        String val;
        int exprStartDelimiter;
        String pathExpression;
        int pathSeparator;
        Object value = null;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf("}", index)) >= 0) {
                Object subResult;
                String retVal = expr.substring(0, index);
                retVal = index > 0 && expr.charAt(index - 1) == '$' ? retVal + expr.substring(index + 1, lastIndex + 1) : ((subResult = this.evaluate(expr.substring(index, lastIndex + 1))) != null ? retVal + subResult : retVal + "$" + expr.substring(index + 1, lastIndex + 1));
                retVal = retVal + this.evaluate(expr.substring(lastIndex + 1));
                return retVal;
            }
            if (expression.indexOf("$$") > -1) {
                return expression.replaceAll("\\$\\$", "\\$");
            }
            return expression;
        }
        if ("project".equals(expression)) {
            value = this.project;
        } else if ("executedProject".equals(expression)) {
            value = this.project.getExecutionProject();
        } else if (expression.startsWith("project")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(0, pathSeparator);
                    value = ReflectionValueExtractor.evaluate((String)pathExpression, (Object)this.project);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate((String)expression.substring(1), (Object)this.project);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, (Throwable)e);
            }
        } else if ("settings".equals(expression)) {
            value = this.settings;
        } else if (expression.startsWith("settings")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate((String)pathExpression, (Object)this.settings);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate((String)expression.substring(1), (Object)this.settings);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, (Throwable)e);
            }
        } else if ("basedir".equals(expression)) {
            value = this.basedir;
        } else if (expression.startsWith("basedir") && (pathSeparator = expression.indexOf("/")) > 0) {
            value = this.basedir + expression.substring(pathSeparator);
        }
        if (value == null) {
            if (value == null && this.properties != null) {
                value = this.properties.getProperty(expression);
            }
            if (value == null && this.project != null && this.project.getProperties() != null) {
                value = this.project.getProperties().getProperty(expression);
            }
        }
        if (value instanceof String && (exprStartDelimiter = (val = (String)value).indexOf("${")) >= 0) {
            value = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + this.evaluate(val.substring(exprStartDelimiter)) : this.evaluate(val.substring(exprStartDelimiter));
        }
        return value;
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf("}") == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public File alignToBaseDirectory(File file) {
        return new File(this.pathTranslator.alignToBaseDirectory(file.getPath(), new File(this.basedir)));
    }
}

