/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav.replication;

import it.could.util.StreamTools;
import it.could.util.http.WebDavClient;
import it.could.util.location.Location;
import it.could.webdav.DAVInputStream;
import it.could.webdav.DAVListener;
import it.could.webdav.DAVLogger;
import it.could.webdav.DAVRepository;
import it.could.webdav.DAVResource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DAVReplica
extends Thread
implements DAVListener {
    private static final int SYNCHRONIZE = -1;
    private final DAVRepository repository;
    private final DAVLogger logger;
    private final Location location;
    private final List actions = new ArrayList();

    public DAVReplica(DAVRepository repository, Location location, DAVLogger logger) throws IOException {
        this.location = new WebDavClient(location).getLocation();
        this.repository = repository;
        this.logger = logger;
        this.start();
    }

    public void synchronize() throws IOException {
        this.logger.log("Scheduling full synchronization");
        this.notify(this.repository.getResource((String)null), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(DAVResource resource, int event) {
        this.logger.debug("Event for \"" + resource.getRelativePath() + "\"");
        if (resource.getRepository() != this.repository) {
            return;
        }
        List list = this.actions;
        synchronized (list) {
            this.actions.add(new Action(resource, event));
            this.actions.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logger.debug("Starting background replica thread on " + this.location);
        while (true) {
            try {
                block10: while (true) {
                    Action[] array;
                    List list = this.actions;
                    synchronized (list) {
                        try {
                            if (this.actions.isEmpty()) {
                                this.actions.wait();
                            }
                            int s = this.actions.size();
                            array = this.actions.toArray(new Action[s]);
                            this.actions.clear();
                        }
                        catch (InterruptedException exception) {
                            this.logger.debug("Exiting background replica thread");
                            return;
                        }
                    }
                    int x = 0;
                    while (true) {
                        if (x >= array.length) continue block10;
                        try {
                            this.replicate(array[x]);
                        }
                        catch (Throwable throwable) {
                            String path = array[x].resource.getRelativePath();
                            String message = "Error synchronizing resource " + path;
                            this.logger.log(message, throwable);
                        }
                        ++x;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.logger.log("Replica thread attempted suicide", throwable);
                continue;
            }
            break;
        }
    }

    private void replicate(Action action) {
        DAVResource resource = action.resource;
        if (action.event == -1) {
            this.synchronize(resource);
        } else {
            try {
                String path = resource.getParent().getRelativePath();
                Location location = this.location.resolve(path);
                WebDavClient client = new WebDavClient(location);
                String child = resource.getName();
                switch (action.event) {
                    case 3: 
                    case 5: {
                        this.logger.debug("Putting resource " + path);
                        this.put(resource, client);
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.logger.debug("Deleting resource " + path);
                        client.delete(child);
                        break;
                    }
                    case 1: {
                        this.logger.debug("Creating collection " + path);
                        client.mkcol(child);
                    }
                }
            }
            catch (IOException exception) {
                String message = "Error replicating " + resource.getRelativePath();
                this.logger.log(message, exception);
            }
        }
    }

    private void put(DAVResource resource, WebDavClient client) throws IOException {
        String name = resource.getName();
        long length = resource.getContentLength();
        OutputStream output = client.put(name, length);
        DAVInputStream input = resource.read();
        StreamTools.copy(input, output);
    }

    private void synchronize(DAVResource resource) {
        WebDavClient client;
        String path = resource.getRelativePath();
        if (!resource.isCollection()) {
            this.logger.log("Synchronization on non-collection " + path);
            return;
        }
        this.logger.log("Synchronizing collection " + path);
        try {
            Location location = this.location.resolve(path);
            client = new WebDavClient(location);
        }
        catch (IOException exception) {
            this.logger.log("Error creating WebDAV client", exception);
            return;
        }
        HashSet children = new HashSet();
        Iterator iter = client.iterator();
        while (iter.hasNext()) {
            children.add(iter.next());
        }
        iter = resource.getChildren();
        while (iter.hasNext()) {
            DAVResource child = (DAVResource)iter.next();
            String name = child.getName();
            children.remove(name);
            if (!client.hasChild(name)) {
                try {
                    if (child.isCollection()) {
                        this.logger.debug("Client doesn't have collection " + name);
                        client.mkcol(name);
                        this.synchronize(child);
                        continue;
                    }
                    this.logger.debug("Client doesn't have resource " + name);
                    this.put(child, client);
                }
                catch (IOException exception) {
                    this.logger.log("Error creating new child " + name, exception);
                }
                continue;
            }
            if (child.isCollection()) {
                try {
                    if (!client.isCollection(name)) {
                        this.logger.debug("Recreating collection " + name);
                        client.delete(name).mkcol(name);
                    }
                    this.synchronize(child);
                }
                catch (IOException exception) {
                    this.logger.log("Error creating collection " + name, exception);
                }
                continue;
            }
            try {
                Date rlast = child.getLastModified();
                Date dlast = client.getLastModified(name);
                if (rlast == null || !rlast.equals(dlast)) continue;
                Long rlen = child.getContentLength();
                long dlen = client.getContentLength(name);
                if (rlen != null && rlen == dlen) continue;
                this.logger.debug("Resending resource " + name);
                this.put(child, client.delete(name));
            }
            catch (IOException exception) {
                this.logger.log("Error resending resource " + name, exception);
            }
        }
        iter = children.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            try {
                this.logger.debug("Removing leftovers " + name);
                client.delete(name);
            }
            catch (IOException exception) {
                this.logger.log("Error removing left over " + name, exception);
            }
        }
    }

    private static final class Action {
        final DAVResource resource;
        final int event;

        private Action(DAVResource resource, int event) {
            this.resource = resource;
            this.event = event;
        }
    }
}

