/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav.methods;

import it.could.webdav.DAVInputStream;
import it.could.webdav.DAVResource;
import it.could.webdav.DAVTransaction;
import it.could.webdav.methods.HEAD;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeSet;

public class GET
extends HEAD {
    public static final String ENCODING = "UTF-8";
    public static final String COLLECTION_MIME_TYPE = "text/html ;charset=\"UTF-8\"";

    public void process(DAVTransaction transaction, DAVResource resource) throws IOException {
        Closeable out;
        String parent;
        String current;
        super.process(transaction, resource);
        String originalPath = transaction.getOriginalPath();
        String normalizedPath = transaction.getNormalizedPath();
        if (originalPath.equals(normalizedPath)) {
            String relativePath = resource.getRelativePath();
            current = relativePath.equals("") ? transaction.lookup(resource).toASCIIString() : relativePath;
            parent = "./";
        } else {
            current = "./";
            parent = "../";
        }
        if (resource.isCollection()) {
            out = transaction.write(ENCODING);
            String path = resource.getRelativePath();
            ((PrintWriter)out).println("<html>");
            ((PrintWriter)out).println("<head>");
            ((PrintWriter)out).println("<title>Collection: /" + path + "</title>");
            ((PrintWriter)out).println("</head>");
            ((PrintWriter)out).println("<body>");
            ((PrintWriter)out).println("<h2>Collection: /" + path + "</h2>");
            ((PrintWriter)out).println("<ul>");
            DAVResource parentResource = resource.getParent();
            if (parentResource != null) {
                ((PrintWriter)out).print("<li><a href=\"");
                ((PrintWriter)out).print(parent);
                ((PrintWriter)out).print("\">");
                ((PrintWriter)out).print(parentResource.getDisplayName());
                ((PrintWriter)out).println("</a> <i><small>(Parent)</small></i></li>");
                ((PrintWriter)out).println("</ul>");
                ((PrintWriter)out).println("<ul>");
            }
            TreeSet<String> resources = new TreeSet<String>();
            TreeSet<String> collections = new TreeSet<String>();
            Iterator iterator = resource.getChildren();
            while (iterator.hasNext()) {
                DAVResource child = (DAVResource)iterator.next();
                StringBuffer buffer = new StringBuffer();
                String childPath = child.getDisplayName();
                buffer.append("<li><a href=\"");
                buffer.append(current);
                buffer.append(childPath);
                buffer.append("\">");
                buffer.append(childPath);
                buffer.append("</li>");
                if (child.isCollection()) {
                    collections.add(buffer.toString());
                    continue;
                }
                resources.add(buffer.toString());
            }
            Iterator i = collections.iterator();
            while (i.hasNext()) {
                ((PrintWriter)out).println(i.next());
            }
            i = resources.iterator();
            while (i.hasNext()) {
                ((PrintWriter)out).println(i.next());
            }
            ((PrintWriter)out).println("</ul>");
            ((PrintWriter)out).println("</body>");
            ((PrintWriter)out).println("</html>");
            ((PrintWriter)out).flush();
            return;
        }
        out = transaction.write();
        DAVInputStream in = resource.read();
        byte[] buffer = new byte[4096];
        int k = -1;
        while ((k = in.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, k);
        }
        ((OutputStream)out).flush();
    }
}

