/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class DAVUtilities {
    private static Map MIME_TYPES;
    private static Properties PROPERTIES;
    private static final String FORMAT_822 = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String FORMAT_ISO = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final TimeZone TIMEZONE;
    private static final Locale LOCALE;
    public static final String SERVLET_SIGNATURE;
    public static final String SERVLET_INFORMATION;
    static /* synthetic */ Class class$it$could$webdav$DAVUtilities;

    private DAVUtilities() {
    }

    public static String getProperty(String name) {
        if (name == null) {
            return null;
        }
        return PROPERTIES.getProperty(name);
    }

    public static String getMimeType(String name) {
        if (name == null) {
            return null;
        }
        Iterator iterator = MIME_TYPES.keySet().iterator();
        while (iterator.hasNext()) {
            String extension = (String)iterator.next();
            if (!name.endsWith(extension)) continue;
            return (String)MIME_TYPES.get(extension);
        }
        return null;
    }

    public static String getStatusMessage(int status) {
        switch (status) {
            case 100: {
                return "100 Continue";
            }
            case 101: {
                return "101 Switching Protocols";
            }
            case 200: {
                return "200 OK";
            }
            case 201: {
                return "201 Created";
            }
            case 202: {
                return "202 Accepted";
            }
            case 203: {
                return "203 Non-Authoritative Information";
            }
            case 204: {
                return "204 No Content";
            }
            case 205: {
                return "205 Reset Content";
            }
            case 206: {
                return "206 Partial Content";
            }
            case 300: {
                return "300 Multiple Choices";
            }
            case 301: {
                return "301 Moved Permanently";
            }
            case 302: {
                return "302 Found";
            }
            case 303: {
                return "303 See Other";
            }
            case 304: {
                return "304 Not Modified";
            }
            case 305: {
                return "305 Use Proxy";
            }
            case 306: {
                return "306 (Unused)";
            }
            case 307: {
                return "307 Temporary Redirect";
            }
            case 400: {
                return "400 Bad Request";
            }
            case 401: {
                return "401 Unauthorized";
            }
            case 402: {
                return "402 Payment Required";
            }
            case 403: {
                return "403 Forbidden";
            }
            case 404: {
                return "404 Not Found";
            }
            case 405: {
                return "405 Method Not Allowed";
            }
            case 406: {
                return "406 Not Acceptable";
            }
            case 407: {
                return "407 Proxy Authentication Required";
            }
            case 408: {
                return "408 Request Timeout";
            }
            case 409: {
                return "409 Conflict";
            }
            case 410: {
                return "410 Gone";
            }
            case 411: {
                return "411 Length Required";
            }
            case 412: {
                return "412 Precondition Failed";
            }
            case 413: {
                return "413 Request Entity Too Large";
            }
            case 414: {
                return "414 Request-URI Too Long";
            }
            case 415: {
                return "415 Unsupported Media Type";
            }
            case 416: {
                return "416 Requested Range Not Satisfiable";
            }
            case 417: {
                return "417 Expectation Failed";
            }
            case 500: {
                return "500 Internal Server Error";
            }
            case 501: {
                return "501 Not Implemented";
            }
            case 502: {
                return "502 Bad Gateway";
            }
            case 503: {
                return "503 Service Unavailable";
            }
            case 504: {
                return "504 Gateway Timeout";
            }
            case 505: {
                return "505 HTTP Version Not Supported";
            }
            case 102: {
                return "102 Processing";
            }
            case 207: {
                return "207 Multi-Status";
            }
            case 422: {
                return "422 Unprocessable Entity";
            }
            case 423: {
                return "423 Locked";
            }
            case 424: {
                return "424 Failed Dependency";
            }
            case 507: {
                return "507 Insufficient Storage";
            }
        }
        return null;
    }

    public static String formatNumber(Number number) {
        if (number == null) {
            return null;
        }
        return number.toString();
    }

    public static Long parseNumber(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Long(string);
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    public static String formatHttpDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_822, LOCALE);
        formatter.setTimeZone(TIMEZONE);
        return formatter.format(date);
    }

    public static String formatIsoDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_ISO, LOCALE);
        formatter.setTimeZone(TIMEZONE);
        return formatter.format(date);
    }

    public static Date parseHttpDate(String string) {
        if (string == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_822, LOCALE);
        formatter.setTimeZone(TIMEZONE);
        try {
            return formatter.parse(string);
        }
        catch (ParseException exception) {
            return null;
        }
    }

    public static Date parseIsoDate(String string) {
        if (string == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_ISO, LOCALE);
        formatter.setTimeZone(TIMEZONE);
        try {
            return formatter.parse(string);
        }
        catch (ParseException exception) {
            return null;
        }
    }

    public static String toHexString(byte[] buffer) {
        char[] output = new char[buffer.length * 2];
        int position = 0;
        for (int x = 0; x < buffer.length; ++x) {
            output[position++] = DAVUtilities.toHexDigit(buffer[x] >> 4);
            output[position++] = DAVUtilities.toHexDigit(buffer[x]);
        }
        return new String(output);
    }

    public static String toHexString(long number) {
        char[] output = new char[]{DAVUtilities.toHexDigit((int)(number >> 60)), DAVUtilities.toHexDigit((int)(number >> 56)), DAVUtilities.toHexDigit((int)(number >> 52)), DAVUtilities.toHexDigit((int)(number >> 48)), DAVUtilities.toHexDigit((int)(number >> 44)), DAVUtilities.toHexDigit((int)(number >> 40)), DAVUtilities.toHexDigit((int)(number >> 36)), DAVUtilities.toHexDigit((int)(number >> 32)), DAVUtilities.toHexDigit((int)(number >> 28)), DAVUtilities.toHexDigit((int)(number >> 24)), DAVUtilities.toHexDigit((int)(number >> 20)), DAVUtilities.toHexDigit((int)(number >> 16)), DAVUtilities.toHexDigit((int)(number >> 12)), DAVUtilities.toHexDigit((int)(number >> 8)), DAVUtilities.toHexDigit((int)(number >> 4)), DAVUtilities.toHexDigit((int)number)};
        return new String(output);
    }

    public static String toHexString(int number) {
        char[] output = new char[]{DAVUtilities.toHexDigit(number >> 28), DAVUtilities.toHexDigit(number >> 24), DAVUtilities.toHexDigit(number >> 20), DAVUtilities.toHexDigit(number >> 16), DAVUtilities.toHexDigit(number >> 12), DAVUtilities.toHexDigit(number >> 8), DAVUtilities.toHexDigit(number >> 4), DAVUtilities.toHexDigit(number)};
        return new String(output);
    }

    public static String toHexString(char number) {
        char[] output = new char[]{DAVUtilities.toHexDigit(number >> 12), DAVUtilities.toHexDigit(number >> 8), DAVUtilities.toHexDigit(number >> 4), DAVUtilities.toHexDigit(number)};
        return new String(output);
    }

    public static String toHexString(byte number) {
        char[] output = new char[]{DAVUtilities.toHexDigit(number >> 4), DAVUtilities.toHexDigit(number)};
        return new String(output);
    }

    private static char toHexDigit(int number) {
        switch (number & 0xF) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        String message = "Invalid HEX digit " + Integer.toHexString(number);
        throw new IllegalArgumentException(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String file;
        MIME_TYPES = new HashMap();
        PROPERTIES = new Properties();
        TIMEZONE = TimeZone.getTimeZone("GMT");
        LOCALE = Locale.US;
        Class clazz = class$it$could$webdav$DAVUtilities == null ? (class$it$could$webdav$DAVUtilities = DAVUtilities.class$("it.could.webdav.DAVUtilities")) : class$it$could$webdav$DAVUtilities;
        ClassLoader loader = clazz.getClassLoader();
        InputStream prop = loader.getResourceAsStream((file = '/' + clazz.getPackage().getName().replace('.', '/')) + "/webdav.props");
        if (prop != null) {
            try {
                PROPERTIES.load(prop);
                prop.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Invalid resource: " + file + "/webdav.props");
        }
        InputStream mime = loader.getResourceAsStream(file + "/mime.types");
        if (mime != null) {
            try {
                InputStreamReader read = new InputStreamReader(mime);
                BufferedReader buff = new BufferedReader(read);
                String line = null;
                while ((line = buff.readLine()) != null) {
                    StringTokenizer tokenizer;
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || (tokenizer = new StringTokenizer(line)).countTokens() <= 1) continue;
                    String type = tokenizer.nextToken();
                    while (tokenizer.hasMoreTokens()) {
                        String extension = '.' + tokenizer.nextToken();
                        MIME_TYPES.put(extension, type);
                    }
                }
                buff.close();
                read.close();
                mime.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Invalid resource: " + file + "/mime.types");
        }
        SERVLET_SIGNATURE = DAVUtilities.getProperty("servlet.signature") + '/' + DAVUtilities.getProperty("version");
        SERVLET_INFORMATION = DAVUtilities.getProperty("servlet.information") + " version " + DAVUtilities.getProperty("version");
    }
}

