/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVException;
import it.could.webdav.DAVResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DAVTransaction {
    public static final int INFINITY = Integer.MAX_VALUE;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private URI base = null;
    private int status = -1;

    public DAVTransaction(ServletRequest request, ServletResponse response) throws ServletException {
        if (request == null) {
            throw new NullPointerException("Null request");
        }
        if (response == null) {
            throw new NullPointerException("Null response");
        }
        this.request = (HttpServletRequest)request;
        this.response = (HttpServletResponse)response;
        this.response.setHeader("DAV", "1");
        this.response.setHeader("MS-Author-Via", "DAV");
        try {
            String scheme = this.request.getScheme();
            String host = this.request.getServerName();
            String path = this.request.getContextPath() + this.request.getServletPath();
            int port = this.request.getServerPort();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.base = new URI(scheme, null, host, port, path, null, null);
            this.base = this.base.normalize();
        }
        catch (URISyntaxException exception) {
            throw new ServletException("Unable to create base URI", (Throwable)exception);
        }
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getOriginalPath() {
        String path = this.request.getPathInfo();
        if (path == null) {
            return "";
        }
        if (path.length() > 1 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    public String getNormalizedPath() {
        String path = this.getOriginalPath();
        if (!path.endsWith("/")) {
            return path;
        }
        return path.substring(0, path.length() - 1);
    }

    public int getDepth() {
        String depth = this.request.getHeader("Depth");
        if (depth == null) {
            return Integer.MAX_VALUE;
        }
        if ("infinity".equals(depth)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(depth);
        }
        catch (NumberFormatException exception) {
            throw new DAVException(412, "Unable to parse depth", exception);
        }
    }

    public URI getDestination() {
        String destination = this.request.getHeader("Destination");
        if (destination != null) {
            try {
                return this.base.relativize(new URI(destination));
            }
            catch (URISyntaxException exception) {
                throw new DAVException(412, "Can't parse destination", exception);
            }
        }
        return null;
    }

    public boolean getOverwrite() {
        String overwrite = this.request.getHeader("Overwrite");
        if (overwrite == null) {
            return true;
        }
        if ("T".equals(overwrite)) {
            return true;
        }
        if ("F".equals(overwrite)) {
            return false;
        }
        throw new DAVException(412, "Unable to parse overwrite flag");
    }

    public Date getIfModifiedSince() {
        String name = "If-Modified-Since";
        if (this.request.getHeader(name) == null) {
            return null;
        }
        return new Date(this.request.getDateHeader(name));
    }

    public void setStatus(int status) {
        this.response.setStatus(status);
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setContentType(String type) {
        this.response.setContentType(type);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public boolean hasRequestBody() throws IOException {
        if (this.request.getHeader("Content-Range") != null) {
            throw new DAVException(501, "Content-Range not supported");
        }
        if (this.request.getContentLength() > 0) {
            return true;
        }
        String len = this.request.getHeader("Content-Length");
        if (len != null) {
            try {
                return Long.parseLong(len) > 0L;
            }
            catch (NumberFormatException exception) {
                throw new DAVException(411, "Invalid Content-Length specified");
            }
        }
        return false;
    }

    public InputStream read() throws IOException {
        if (this.request.getHeader("Content-Range") != null) {
            throw new DAVException(501, "Content-Range not supported");
        }
        if (this.request.getContentLength() >= 0) {
            return this.request.getInputStream();
        }
        String len = this.request.getHeader("Content-Length");
        if (len != null) {
            try {
                if (Long.parseLong(len) >= 0L) {
                    return this.request.getInputStream();
                }
            }
            catch (NumberFormatException exception) {
                throw new DAVException(411, "Invalid Content-Length specified");
            }
        }
        return null;
    }

    public OutputStream write() throws IOException {
        return this.response.getOutputStream();
    }

    public PrintWriter write(String encoding) throws IOException {
        return new PrintWriter(new OutputStreamWriter(this.write(), encoding));
    }

    public URI lookup(DAVResource resource) {
        URI uri = resource.getRelativeURI();
        return this.base.resolve(uri).normalize();
    }
}

