/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVListener;
import it.could.webdav.DAVLogger;
import it.could.webdav.DAVProcessor;
import it.could.webdav.DAVRepository;
import it.could.webdav.DAVResource;
import it.could.webdav.DAVTransaction;
import it.could.webdav.DAVUtilities;
import it.could.webdav.XMLRepository;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DAVServlet
implements Servlet,
DAVListener {
    private ServletContext context = null;
    private ServletConfig config = null;
    private DAVRepository repository = null;
    private DAVProcessor processor = null;
    private DAVLogger logger = null;
    static /* synthetic */ Class class$it$could$webdav$DAVRepository;

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
        boolean debug = "true".equals(config.getInitParameter("debugEnabled"));
        this.logger = new DAVLogger(config, debug);
        String rootPath = config.getInitParameter("rootPath");
        if (rootPath == null) {
            throw new ServletException("Parameter \"rootPath\" not specified");
        }
        try {
            File root = new File(rootPath);
            if (!root.isAbsolute()) {
                URL url = this.context.getResource("/" + rootPath);
                if (!"file".equals(url.getProtocol())) {
                    throw new ServletException("Invalid root \"" + url + "\"");
                }
                root = new File(url.getPath());
            }
            this.repository = "true".equalsIgnoreCase(config.getInitParameter("xmlOnly")) ? new XMLRepository(root) : new DAVRepository(root);
            this.processor = new DAVProcessor(this.repository);
            this.repository.addListener(this);
            this.logger.log("Initialized from " + root.getPath());
        }
        catch (MalformedURLException e) {
            throw new ServletException("Can't resolve \"" + rootPath + "\"", (Throwable)e);
        }
        catch (IOException e) {
            String msg = "Can't initialize repository at \"" + rootPath + "\"";
            throw new ServletException(msg, (Throwable)e);
        }
        String key = DAVServlet.getRepositoryKey(config.getServletName());
        this.context.setAttribute(key, (Object)this.repository);
    }

    public DAVRepository getRepository(File root) throws IOException {
        return new XMLRepository(root);
    }

    public void destroy() {
        this.repository.removeListener(this);
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getServletInfo() {
        return DAVUtilities.SERVLET_INFORMATION;
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        res.setHeader("Server", this.context.getServerInfo() + ' ' + DAVUtilities.SERVLET_SIGNATURE);
        DAVTransaction transaction = new DAVTransaction((ServletRequest)req, (ServletResponse)res);
        try {
            this.processor.process(transaction);
        }
        catch (RuntimeException exception) {
            String header = req.getMethod() + ' ' + req.getRequestURI() + ' ' + req.getProtocol();
            this.context.log("Error processing: " + header);
            this.context.log("Exception processing DAV transaction", (Throwable)exception);
            throw exception;
        }
    }

    public void notify(DAVResource resource, int event) {
        String message = "Unknown event";
        switch (event) {
            case 1: {
                message = "Collection created";
                break;
            }
            case 2: {
                message = "Collection removed";
                break;
            }
            case 3: {
                message = "Resource created";
                break;
            }
            case 4: {
                message = "Resource removed";
                break;
            }
            case 5: {
                message = "Resource modified";
            }
        }
        this.logger.debug(message + ": \"" + resource.getRelativePath() + "\"");
    }

    public static String getRepositoryKey(String servletName) {
        if (servletName == null) {
            throw new NullPointerException();
        }
        return (class$it$could$webdav$DAVRepository == null ? (class$it$could$webdav$DAVRepository = DAVServlet.class$("it.could.webdav.DAVRepository")) : class$it$could$webdav$DAVRepository).getName() + "." + servletName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

