/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVException;
import it.could.webdav.DAVInputStream;
import it.could.webdav.DAVMultiStatus;
import it.could.webdav.DAVOutputStream;
import it.could.webdav.DAVRepository;
import it.could.webdav.DAVUtilities;
import java.io.File;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class DAVResource
implements Comparable {
    public static final String COLLECTION_MIME_TYPE = "httpd/unix-directory";
    protected static final String PREFIX = ".dav_";
    protected static final String SUFFIX = ".temp";
    private DAVRepository repository = null;
    private File file = null;

    protected DAVResource(DAVRepository repo, File file) {
        if (repo == null) {
            throw new NullPointerException("Null repository");
        }
        if (file == null) {
            throw new NullPointerException("Null resource");
        }
        this.repository = repo;
        this.file = file;
        if (this.getRelativeURI().isAbsolute()) {
            throw new DAVException(412, "Error relativizing resource");
        }
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof DAVResource) {
            DAVResource resource = (DAVResource)object;
            boolean u = this.file.equals(resource.file);
            boolean r = this.repository == resource.repository;
            return u && r;
        }
        return false;
    }

    public int compareTo(Object object) {
        DAVResource resource = (DAVResource)object;
        return this.file.compareTo(resource.file);
    }

    public boolean isNull() {
        return !this.file.exists();
    }

    public boolean isCollection() {
        if (this.isNull()) {
            return false;
        }
        return this.file.isDirectory();
    }

    public boolean isResource() {
        if (this.isNull()) {
            return false;
        }
        return !this.isCollection();
    }

    protected File getFile() {
        return this.file;
    }

    public DAVRepository getRepository() {
        return this.repository;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getDisplayName() {
        String name = this.getName();
        if (this.isCollection()) {
            return name + "/";
        }
        return name;
    }

    public String getRelativePath() {
        return this.getRelativeURI().toASCIIString();
    }

    public URI getRelativeURI() {
        URI uri = this.file.toURI();
        return this.repository.getRepositoryURI().relativize(uri).normalize();
    }

    public DAVResource getParent() {
        try {
            return new DAVResource(this.repository, this.file.getParentFile());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Iterator getChildren() {
        if (!this.isCollection()) {
            return null;
        }
        File[] children = this.file.listFiles();
        if (children == null) {
            children = new File[]{};
        }
        ArrayList<DAVResource> resources = new ArrayList<DAVResource>(children.length);
        for (int x = 0; x < children.length; ++x) {
            String c = children[x].getName();
            if (c.startsWith(PREFIX) && c.endsWith(SUFFIX)) continue;
            resources.add(new DAVResource(this.repository, children[x]));
        }
        return resources.iterator();
    }

    public String getContentType() {
        if (this.isNull()) {
            return null;
        }
        if (this.isCollection()) {
            return COLLECTION_MIME_TYPE;
        }
        return DAVUtilities.getMimeType(this.getDisplayName());
    }

    public Long getContentLength() {
        if (this.isNull() || this.isCollection()) {
            return null;
        }
        return new Long(this.file.length());
    }

    public Date getCreationDate() {
        if (this.isNull()) {
            return null;
        }
        return new Date(this.file.lastModified());
    }

    public Date getLastModified() {
        if (this.isNull()) {
            return null;
        }
        return new Date(this.file.lastModified());
    }

    public String getEntityTag() {
        if (this.isNull()) {
            return null;
        }
        String path = this.getRelativePath();
        StringBuffer etag = new StringBuffer();
        etag.append('\"');
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            digester.reset();
            digester.update(path.getBytes("UTF8"));
            etag.append(DAVUtilities.toHexString(digester.digest()));
            etag.append('-');
        }
        catch (Exception e) {
            // empty catch block
        }
        etag.append(DAVUtilities.toHexString(path.hashCode()));
        Date date = this.getLastModified();
        if (date != null) {
            etag.append('-');
            etag.append(DAVUtilities.toHexString(date.getTime()));
        }
        etag.append('\"');
        return etag.toString();
    }

    public void delete() throws DAVMultiStatus {
        if (this.isNull()) {
            throw new DAVException(404, "Not found", this);
        }
        if (this.isResource()) {
            if (!this.file.delete()) {
                throw new DAVException(403, "Can't delete resource", this);
            }
            this.repository.notify(this, 4);
        } else if (this.isCollection()) {
            DAVMultiStatus multistatus = new DAVMultiStatus();
            Iterator children = this.getChildren();
            while (children.hasNext()) {
                try {
                    ((DAVResource)children.next()).delete();
                }
                catch (DAVException exception) {
                    multistatus.merge(exception);
                }
            }
            if (multistatus.size() > 0) {
                throw multistatus;
            }
            if (!this.file.delete()) {
                throw new DAVException(403, "Can't delete collection", this);
            }
            this.repository.notify(this, 2);
        }
    }

    public void copy(DAVResource dest, boolean overwrite, boolean recursive) throws DAVMultiStatus {
        if (this.isNull()) {
            throw new DAVException(404, "Not found", this);
        }
        if (!dest.isNull()) {
            if (!overwrite) {
                String msg = "Not overwriting existing destination";
                throw new DAVException(412, msg, dest);
            }
            dest.delete();
        }
        if (this.isResource()) {
            DAVInputStream in = this.read();
            DAVOutputStream out = dest.write();
            byte[] buffer = new byte[4096];
            int k = -1;
            while ((k = in.read(buffer)) != -1) {
                out.write(buffer, 0, k);
            }
            out.close();
        }
        if (this.isCollection()) {
            dest.makeCollection();
            if (!recursive) {
                return;
            }
            DAVMultiStatus multistatus = new DAVMultiStatus();
            Iterator children = this.getChildren();
            while (children.hasNext()) {
                try {
                    DAVResource childResource = (DAVResource)children.next();
                    File child = new File(dest.file, childResource.file.getName());
                    DAVResource target = new DAVResource(this.repository, child);
                    childResource.copy(target, overwrite, recursive);
                }
                catch (DAVException exception) {
                    multistatus.merge(exception);
                }
            }
            if (multistatus.size() > 0) {
                throw multistatus;
            }
        }
    }

    public void makeCollection() {
        DAVResource parent = this.getParent();
        if (!this.isNull()) {
            throw new DAVException(405, "Resource exists", this);
        }
        if (parent.isNull()) {
            throw new DAVException(409, "Parent does not not exist", this);
        }
        if (!parent.isCollection()) {
            throw new DAVException(403, "Parent not a collection", this);
        }
        if (!this.file.mkdir()) {
            throw new DAVException(507, "Can't create collection", this);
        }
        this.repository.notify(this, 1);
    }

    public DAVInputStream read() {
        if (this.isNull()) {
            throw new DAVException(404, "Not found", this);
        }
        if (this.isCollection()) {
            throw new DAVException(403, "Resource is collection", this);
        }
        return new DAVInputStream(this);
    }

    public DAVOutputStream write() {
        DAVResource parent = this.getParent();
        if (this.isCollection()) {
            throw new DAVException(409, "Can't write a collection", this);
        }
        if (parent.isNull()) {
            throw new DAVException(409, "Parent doesn't exist", this);
        }
        if (!parent.isCollection()) {
            throw new DAVException(403, "Parent not a collection", this);
        }
        return new DAVOutputStream(this);
    }
}

