/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVException;
import it.could.webdav.DAVResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DAVOutputStream
extends OutputStream {
    private File temporary = null;
    private OutputStream output = null;
    private DAVResource resource = null;

    protected DAVOutputStream(DAVResource resource) {
        if (resource == null) {
            throw new NullPointerException();
        }
        this.resource = resource;
        try {
            this.temporary = resource.getParent().getFile();
            this.temporary = File.createTempFile(".dav_", ".temp", this.temporary);
            this.output = new FileOutputStream(this.temporary);
        }
        catch (IOException e) {
            String message = "Unable to create temporary file";
            throw new DAVException(507, message, e, resource);
        }
    }

    protected void rename(File temporary, File original) throws IOException {
        if (original.exists() && !original.delete()) {
            throw new IOException("Unable to delete original file");
        }
        if (!temporary.renameTo(original)) {
            throw new IOException("Unable to rename temporary file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.temporary.exists()) {
            this.temporary.delete();
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.output = null;
            }
        }
    }

    public void close() {
        if (this.output == null) {
            return;
        }
        try {
            int event = this.resource.getFile().exists() ? 5 : 3;
            this.output.close();
            this.output = null;
            this.rename(this.temporary, this.resource.getFile());
            this.resource.getRepository().notify(this.resource, event);
        }
        catch (IOException e) {
            String message = "Error processing temporary file";
            throw new DAVException(507, message, e, this.resource);
        }
        finally {
            this.abort();
        }
    }

    public void flush() {
        if (this.output == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            this.output.flush();
        }
        catch (IOException e) {
            this.abort();
            String message = "Unable to flush buffers";
            throw new DAVException(507, message, e, this.resource);
        }
    }

    public void write(int b) {
        if (this.output == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            this.output.write(b);
        }
        catch (IOException e) {
            this.abort();
            String message = "Unable to write data";
            throw new DAVException(507, message, e, this.resource);
        }
    }

    public void write(byte[] b) {
        if (this.output == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            this.output.write(b);
        }
        catch (IOException e) {
            this.abort();
            String message = "Unable to write data";
            throw new DAVException(507, message, e, this.resource);
        }
    }

    public void write(byte[] b, int o, int l) {
        if (this.output == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            this.output.write(b, o, l);
        }
        catch (IOException e) {
            this.abort();
            String message = "Unable to write data";
            throw new DAVException(507, message, e, this.resource);
        }
    }

    public void finalize() {
        this.abort();
    }
}

