/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVException;
import it.could.webdav.DAVResource;
import it.could.webdav.DAVTransaction;
import it.could.webdav.DAVUtilities;
import java.io.IOException;

public class DAVNotModified
extends DAVException {
    private DAVResource resource = null;

    public DAVNotModified(DAVResource resource) {
        super(304, "Resource Not Modified");
        this.resource = resource;
    }

    public void write(DAVTransaction transaction) throws IOException {
        transaction.setStatus(this.getStatus());
        String etag = this.resource.getEntityTag();
        String lmod = DAVUtilities.formatHttpDate(this.resource.getLastModified());
        if (etag != null) {
            transaction.setHeader("ETag", etag);
        }
        if (lmod != null) {
            transaction.setHeader("Last-Modified", lmod);
        }
    }
}

