/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVResource;
import it.could.webdav.DAVTransaction;
import it.could.webdav.DAVUtilities;
import java.io.IOException;
import java.io.PrintWriter;

public class DAVException
extends RuntimeException {
    private DAVResource resource = null;
    private int status = 0;

    public DAVException(int status, String message) {
        this(status, message, null, null);
    }

    public DAVException(int status, String message, Throwable throwable) {
        this(status, message, throwable, null);
    }

    public DAVException(int status, String message, DAVResource resource) {
        this(status, message, null, resource);
    }

    public DAVException(int s, String m, Throwable t, DAVResource r) {
        super(m, t);
        this.resource = r;
        this.status = s;
    }

    public int getStatus() {
        return this.status;
    }

    public DAVResource getResource() {
        return this.resource;
    }

    public void write(DAVTransaction transaction) throws IOException {
        transaction.setContentType("text/html; charset=\"UTF-8\"");
        transaction.setStatus(this.getStatus());
        String message = DAVUtilities.getStatusMessage(this.getStatus());
        if (message == null) {
            transaction.setStatus(500);
            message = Integer.toString(this.getStatus()) + " Unknown";
        }
        PrintWriter out = transaction.write("UTF-8");
        out.println("<html>");
        out.print("<head><title>Error ");
        out.print(message);
        out.println("</title></head>");
        out.println("<body>");
        out.print("<p><b>Error ");
        out.print(message);
        out.println("</b></p>");
        if (this.getResource() != null) {
            String r = transaction.lookup(this.getResource()).toASCIIString();
            out.print("<p>Resource in error: <a href=\"");
            out.print(r);
            out.println("\">");
            out.print(r);
            out.println("</a></p>");
        }
        Throwable throwable = this;
        out.println("<hr /><p>Exception details:</p>");
        while (throwable != null) {
            out.print("<pre>");
            throwable.printStackTrace(out);
            out.println("</pre>");
            if ((throwable = throwable.getCause()) == null) continue;
            out.println("<hr /><p>Caused by:</p>");
        }
        out.println("</body>");
        out.println("</html>");
        out.flush();
    }
}

