/*
 * Decompiled with CFR 0.152.
 */
package it.could.util.location;

import it.could.util.StringTools;
import it.could.util.encoding.Encodable;
import it.could.util.encoding.EncodingTools;
import it.could.util.location.Parameters;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class Path
extends AbstractList
implements Encodable {
    private final Element[] paths;
    private final Parameters parameters;
    private final boolean absolute;
    private final boolean collection;
    private final String string;

    public Path(List elements, boolean absolute, boolean collection) {
        this(elements, absolute, collection, null);
    }

    public Path(List elements, boolean absolute, boolean collection, Parameters parameters) {
        Stack resolved = Path.resolve(null, absolute, elements);
        Element[] array = new Element[resolved.size()];
        this.paths = resolved.toArray(array);
        this.parameters = parameters;
        this.absolute = absolute;
        this.collection = collection;
        this.string = EncodingTools.toString(this);
    }

    public static Path parse(String path) {
        try {
            return Path.parse(path, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public static Path parse(String path, String encoding) throws UnsupportedEncodingException {
        ArrayList params = new ArrayList();
        ArrayList<Element> elems = new ArrayList<Element>();
        if (path == null || path.length() == 0) {
            return new Path(elems, false, false, null);
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        String[] split = StringTools.splitAll(path, '/');
        boolean absolute = path.charAt(0) == '/';
        Element element = null;
        for (int x = 0; x < split.length; ++x) {
            if (split[x] == null || (element = Path.parsePath(split[x], params, encoding)) == null) continue;
            elems.add(element);
        }
        boolean collection = split[split.length - 1] == null || element == null || element.getName().equals(".") || element.getName().equals("..");
        Parameters parameters = Parameters.create(params, ';');
        return new Path(elems, absolute, collection, parameters);
    }

    private static Element parsePath(String path, List parameters, String encoding) throws UnsupportedEncodingException {
        Element element;
        int pathEnds = StringTools.findFirst(path, "!;");
        if (pathEnds < 0) {
            element = new Element(EncodingTools.urlDecode(path, encoding), null);
        } else if (path.charAt(pathEnds) == ';') {
            String name = path.substring(0, pathEnds);
            String param = path.substring(pathEnds + 1);
            Parameters params = Parameters.parse(param, ';', encoding);
            if (params != null) {
                parameters.addAll(params);
            }
            element = new Element(EncodingTools.urlDecode(name, encoding), null);
        } else {
            String name = path.substring(0, pathEnds);
            String more = path.substring(pathEnds + 1);
            String[] split = StringTools.splitOnce(more, ';', false);
            Parameters params = Parameters.parse(split[1], ';', encoding);
            if (params != null) {
                parameters.addAll(params);
            }
            element = new Element(EncodingTools.urlDecode(name, encoding), EncodingTools.urlDecode(split[0], encoding));
        }
        if (element.toString().length() == 0) {
            return null;
        }
        return element;
    }

    public Path resolve(Path path) {
        ArrayList params = new ArrayList();
        if (this.parameters != null) {
            params.addAll(this.parameters);
        }
        if (path.parameters != null) {
            params.addAll(path.parameters);
        }
        Parameters parameters = Parameters.create(params, ';');
        if (path == null) {
            return this;
        }
        if (path.absolute) {
            return new Path(path, true, path.collection, parameters);
        }
        Stack source = new Stack();
        source.addAll(this);
        if (!this.collection && source.size() > 0) {
            source.pop();
        }
        Stack resolved = Path.resolve(source, this.absolute, path);
        boolean c = path.size() == 0 ? this.collection : path.collection;
        return new Path(resolved, this.absolute, c, parameters);
    }

    public Path resolve(String path) {
        try {
            return this.resolve(Path.parse(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public Path resolve(String path, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (path == null) {
            return this;
        }
        return this.resolve(Path.parse(path, encoding));
    }

    private static Stack resolve(Stack stack, boolean absolute, List elements) {
        if (stack == null) {
            stack = new Stack<Element>();
        }
        boolean atroot = absolute && stack.empty();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            if (".".equals(element.getName())) continue;
            if ("..".equals(element.getName())) {
                if (atroot) continue;
                if (stack.size() == 0) {
                    stack.push(element);
                    continue;
                }
                Element prev = (Element)stack.peek();
                if ("..".equals(prev.getName())) {
                    stack.push(element);
                } else {
                    stack.pop();
                }
                if (!absolute) continue;
                atroot = stack.size() == 0;
                continue;
            }
            stack.push(element);
            atroot = false;
        }
        return stack;
    }

    public Path relativize(String path) {
        try {
            return this.relativize(Path.parse(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public Path relativize(String path, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return this.relativize(Path.parse(path, encoding));
    }

    public Path relativize(Path path) {
        ArrayList parameters = new ArrayList();
        if (this.parameters != null) {
            parameters.addAll(this.parameters);
        }
        if (path.parameters != null) {
            parameters.addAll(path.parameters);
        }
        Parameters params = Parameters.create(parameters, ';');
        if (path.absolute && this.absolute) {
            int num = this.collection ? this.size() : this.size() - 1;
            int skip = 0;
            for (int x = 0; x < num && x < path.size() && path.paths[x].equals(this.paths[x]); ++x) {
                ++skip;
            }
            boolean collection = path.size() > skip ? path.collection : (this.size() > skip ? true : this.collection);
            ArrayList<Element> elems = new ArrayList<Element>();
            for (int x = skip; x < num; ++x) {
                elems.add(new Element("..", null));
            }
            elems.addAll(path.subList(skip, path.size()));
            return new Path(elems, false, collection);
        }
        if (this.absolute && !path.absolute) {
            return this.relativize(this.resolve(path));
        }
        return new Path(path, path.absolute, path.collection, params);
    }

    public Object get(int index) {
        return this.paths[index];
    }

    public int size() {
        return this.paths.length;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.string;
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        if (this.absolute) {
            buffer.append('/');
        }
        int last = this.paths.length - 1;
        for (int x = 0; x < last; ++x) {
            buffer.append(this.paths[x].toString(encoding)).append('/');
        }
        if (last >= 0) {
            buffer.append(this.paths[last].toString(encoding));
            if (this.collection) {
                buffer.append('/');
            }
        }
        if (this.parameters != null) {
            buffer.append(';').append(this.parameters.toString(encoding));
        }
        return buffer.toString();
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Path) {
            return this.string.equals(((Path)object).string);
        }
        return false;
    }

    public static class Element
    implements Encodable {
        private final String name;
        private final String extra;
        private final String string;

        public Element(String name, String extra) {
            if (name == null) {
                throw new NullPointerException("Null path name");
            }
            this.name = name;
            this.extra = extra;
            this.string = EncodingTools.toString(this);
        }

        public String getName() {
            return this.name;
        }

        public String getExtra() {
            return this.extra;
        }

        public String toString() {
            return this.string;
        }

        public String toString(String encoding) throws UnsupportedEncodingException {
            StringBuffer buffer = new StringBuffer();
            buffer.append(EncodingTools.urlEncode(this.name, encoding));
            if (this.extra != null) {
                buffer.append('!');
                buffer.append(EncodingTools.urlEncode(this.extra, encoding));
            }
            return buffer.toString();
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Element) {
                return this.string.equals(((Element)object).string);
            }
            return false;
        }
    }
}

