/*
 * Decompiled with CFR 0.152.
 */
package it.could.util.location;

import it.could.util.StringTools;
import it.could.util.encoding.Encodable;
import it.could.util.encoding.EncodingTools;
import it.could.util.location.Parameters;
import it.could.util.location.Path;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Location
implements Encodable {
    private static final Map schemePorts = new HashMap();
    private final Schemes schemes;
    private final Authority authority;
    private final Path path;
    private final Parameters parameters;
    private final String fragment;
    private final String string;

    public Location(Schemes schemes, Authority authority, Path path, Parameters parameters, String fragment) throws MalformedURLException {
        if (schemes == null && authority != null) {
            throw new MalformedURLException("No schemes specified");
        }
        if (schemes != null && authority == null) {
            throw new MalformedURLException("No authority specified");
        }
        if (path == null) {
            throw new MalformedURLException("No path specified");
        }
        this.schemes = schemes;
        this.authority = authority;
        this.path = path;
        this.parameters = parameters;
        this.fragment = fragment;
        this.string = EncodingTools.toString(this);
    }

    public static Location parse(String url) throws MalformedURLException {
        try {
            return Location.parse(url, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public static Location parse(String url, String encoding) throws MalformedURLException, UnsupportedEncodingException {
        if (url == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        String[] components = Location.parseComponents(url);
        Schemes schemes = Location.parseSchemes(components[0], encoding);
        int port = Location.findPort(schemes, encoding);
        Authority auth = Location.parseAuthority(components[1], port, encoding);
        Path path = Path.parse(components[2], encoding);
        Parameters params = Parameters.parse(components[3], '&', encoding);
        String fragment = components[4];
        return new Location(schemes, auth, path, params, fragment);
    }

    public Schemes getSchemes() {
        return this.schemes;
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public Path getPath() {
        return this.path;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Location) {
            return this.string.equals(((Location)object).string);
        }
        return false;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public String toString() {
        return this.string;
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        if (this.schemes != null) {
            buffer.append(this.schemes.toString(encoding)).append("://");
        }
        if (this.authority != null) {
            buffer.append(this.authority.toString(encoding));
        }
        buffer.append(this.path.toString(encoding));
        if (this.parameters != null) {
            buffer.append('?').append(this.parameters.toString(encoding));
        }
        if (this.fragment != null) {
            buffer.append('#');
            buffer.append(EncodingTools.urlEncode(this.fragment, encoding));
        }
        return buffer.toString();
    }

    public boolean isAbsolute() {
        return this.schemes != null && this.authority != null;
    }

    public boolean isRelative() {
        return !this.isAbsolute() && !this.path.isAbsolute();
    }

    public boolean isAuthoritative(Location location) {
        if (!this.isAbsolute()) {
            return false;
        }
        if (!location.isAbsolute()) {
            return true;
        }
        return this.schemes.equals(location.schemes) && this.authority.equals(location.authority);
    }

    public Location resolve(String url) throws MalformedURLException {
        try {
            return this.resolve(Location.parse(url, "UTF-8"));
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public Location resolve(String url, String encoding) throws MalformedURLException, UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return this.resolve(Location.parse(url, encoding));
    }

    public Location resolve(Location location) {
        Authority auth;
        if (!this.isAuthoritative(location)) {
            return location;
        }
        Schemes schemes = this.schemes;
        if (location.authority != null) {
            String username = location.authority.username != null ? location.authority.username : this.authority.username;
            String password = location.authority.password != null ? location.authority.password : this.authority.password;
            String host = location.authority.host;
            int port = location.authority.port;
            auth = new Authority(username, password, host, port);
        } else {
            auth = this.authority;
        }
        Path path = this.path.resolve(location.path);
        Parameters params = location.parameters;
        String fragment = location.fragment;
        try {
            return new Location(schemes, auth, path, params, fragment);
        }
        catch (MalformedURLException exception) {
            InternalError error = new InternalError("Can't instantiate Location");
            throw (Error)error.initCause(exception);
        }
    }

    public Location relativize(String url) throws MalformedURLException {
        try {
            return this.relativize(Location.parse(url, "UTF-8"));
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public Location relativize(String url, String encoding) throws MalformedURLException, UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return this.relativize(Location.parse(url, encoding));
    }

    /*
     * WARNING - void declaration
     */
    public Location relativize(Location location) {
        Path path;
        if (!location.isAbsolute()) {
            path = this.path.relativize(location.path);
        } else if (this.isAuthoritative(location)) {
            path = this.path.relativize(location.path);
        } else {
            return location;
        }
        try {
            void var2_2;
            return new Location(null, null, (Path)var2_2, location.parameters, location.fragment);
        }
        catch (MalformedURLException exception) {
            InternalError error = new InternalError("Can't instantiate Location");
            throw (Error)error.initCause(exception);
        }
    }

    public static int findPort(List schemes, String encoding) throws UnsupportedEncodingException {
        if (schemes == null) {
            return -1;
        }
        if (schemes.size() < 1) {
            return -1;
        }
        Integer p = (Integer)schemePorts.get(schemes.get(schemes.size() - 1));
        return p == null ? -1 : p;
    }

    private static String[] parseComponents(String url) throws MalformedURLException {
        String auth;
        String afterAuth;
        String afterScheme;
        String scheme;
        int schemeEnd = url.indexOf(":/");
        if (schemeEnd > 0) {
            scheme = url.substring(0, schemeEnd).toLowerCase();
            afterScheme = url.substring(schemeEnd + 2);
        } else {
            if (schemeEnd == 0) {
                throw new MalformedURLException("Missing scheme");
            }
            scheme = null;
            afterScheme = url;
        }
        if (scheme == null) {
            afterAuth = afterScheme;
            auth = null;
        } else if (afterScheme.length() > 0 && afterScheme.charAt(0) == '/') {
            int pathStart = afterScheme.indexOf(47, 1);
            if (pathStart == 1) {
                afterAuth = afterScheme.substring(pathStart);
                auth = null;
            } else if (pathStart > 1) {
                afterAuth = afterScheme.substring(pathStart);
                auth = afterScheme.substring(1, pathStart);
            } else {
                int authEnds = StringTools.findFirst(afterScheme, "?#");
                if (authEnds < 0) {
                    String auth2 = afterScheme.substring(1);
                    return new String[]{scheme, auth2, "/", null, null};
                }
                auth = afterScheme.substring(1, authEnds);
                afterAuth = "/" + afterScheme.substring(authEnds);
            }
        } else {
            afterAuth = url.substring(schemeEnd + 1);
            auth = null;
        }
        int pathEnds = StringTools.findFirst(afterAuth, "?#");
        if (pathEnds < 0) {
            return new String[]{scheme, auth, afterAuth, null, null};
        }
        String path = afterAuth.substring(0, pathEnds);
        String afterPath = afterAuth.substring(pathEnds + 1);
        if (afterAuth.charAt(pathEnds) == '?') {
            int fragmPos = afterPath.indexOf(35);
            if (fragmPos < 0) {
                return new String[]{scheme, auth, path, afterPath, null};
            }
            String query = afterPath.substring(1, fragmPos);
            String fragm = afterPath.substring(fragmPos + 1);
            return new String[]{scheme, auth, path, query, fragm};
        }
        return new String[]{scheme, auth, path, null, afterPath};
    }

    private static Schemes parseSchemes(String scheme, String encoding) throws MalformedURLException, UnsupportedEncodingException {
        if (scheme == null) {
            return null;
        }
        String[] split = StringTools.splitAll(scheme, ':');
        ArrayList<String> list = new ArrayList<String>();
        for (int x = 0; x < split.length; ++x) {
            if (split[x] == null) continue;
            list.add(EncodingTools.urlDecode(split[x], encoding));
        }
        if (list.size() != 0) {
            return new Schemes(list);
        }
        throw new MalformedURLException("Empty scheme detected");
    }

    private static Authority parseAuthority(String auth, int defaultPort, String encoding) throws MalformedURLException, UnsupportedEncodingException {
        int port;
        if (auth == null) {
            return null;
        }
        String[] split = StringTools.splitOnce(auth, '@', true);
        String[] uinfo = StringTools.splitOnce(split[0], ':', false);
        String[] hinfo = StringTools.splitOnce(split[1], ':', false);
        if (split[0] != null && split[1] == null) {
            throw new MalformedURLException("Missing required host info part");
        }
        if (uinfo[0] == null && uinfo[1] != null) {
            throw new MalformedURLException("Password specified without user");
        }
        if (hinfo[0] == null && hinfo[1] != null) {
            throw new MalformedURLException("Port specified without host");
        }
        try {
            if (hinfo[1] != null) {
                int parsedPort = Integer.parseInt(hinfo[1]);
                if (parsedPort < 1 || parsedPort > 65535) {
                    String message = "Invalid port number " + parsedPort;
                    throw new MalformedURLException(message);
                }
                port = defaultPort == parsedPort ? -1 : parsedPort;
            } else {
                port = -1;
            }
        }
        catch (NumberFormatException exception) {
            throw new MalformedURLException("Specified port is not a number");
        }
        return new Authority(EncodingTools.urlDecode(uinfo[0], encoding), EncodingTools.urlDecode(uinfo[1], encoding), EncodingTools.urlDecode(hinfo[0], encoding), port);
    }

    static {
        schemePorts.put("acap", new Integer(674));
        schemePorts.put("dav", new Integer(80));
        schemePorts.put("ftp", new Integer(21));
        schemePorts.put("gopher", new Integer(70));
        schemePorts.put("http", new Integer(80));
        schemePorts.put("https", new Integer(443));
        schemePorts.put("imap", new Integer(143));
        schemePorts.put("ldap", new Integer(389));
        schemePorts.put("mailto", new Integer(25));
        schemePorts.put("news", new Integer(119));
        schemePorts.put("nntp", new Integer(119));
        schemePorts.put("pop", new Integer(110));
        schemePorts.put("rtsp", new Integer(554));
        schemePorts.put("sip", new Integer(5060));
        schemePorts.put("sips", new Integer(5061));
        schemePorts.put("snmp", new Integer(161));
        schemePorts.put("telnet", new Integer(23));
        schemePorts.put("tftp", new Integer(69));
    }

    public static class Authority
    implements Encodable {
        private final String username;
        private final String password;
        private final String host;
        private final int port;
        private final String hostinfo;
        private final String string;

        private Authority(String user, String pass, String host, int port) {
            this.username = user;
            this.password = pass;
            this.host = host;
            this.port = port;
            try {
                this.hostinfo = this.getHostInfo("UTF-8");
                this.string = this.toString("UTF-8");
            }
            catch (UnsupportedEncodingException exception) {
                String message = "Default encoding \"UTF-8\" not supported by the platform";
                InternalError error = new InternalError("Default encoding \"UTF-8\" not supported by the platform");
                throw (InternalError)error.initCause(exception);
            }
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUserInfo() {
            if (this.username == null || this.password == null) {
                return null;
            }
            return this.username + ':' + this.password;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getHostInfo() {
            return this.hostinfo;
        }

        public String getHostInfo(String encoding) throws UnsupportedEncodingException {
            StringBuffer hostinfo = new StringBuffer();
            hostinfo.append(EncodingTools.urlEncode(this.host, encoding));
            if (this.port >= 0) {
                hostinfo.append(':').append(this.port);
            }
            return hostinfo.toString();
        }

        public String toString() {
            return this.string;
        }

        public String toString(String encoding) throws UnsupportedEncodingException {
            StringBuffer buffer;
            if (this.username != null) {
                buffer = new StringBuffer();
                buffer.append(EncodingTools.urlEncode(this.username, encoding));
                if (this.password != null) {
                    buffer.append(':');
                    buffer.append(EncodingTools.urlEncode(this.password, encoding));
                }
            } else {
                buffer = null;
            }
            if (buffer == null) {
                return this.getHostInfo(encoding);
            }
            buffer.append('@').append(this.getHostInfo(encoding));
            return buffer.toString();
        }

        public int hashCode() {
            return this.hostinfo.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Authority) {
                return this.hostinfo.equals(((Authority)object).hostinfo);
            }
            return false;
        }
    }

    public static class Schemes
    extends AbstractList
    implements Encodable {
        private final String[] schemes;
        private final String string;

        private Schemes(List schemes) {
            int size = schemes.size();
            this.schemes = schemes.toArray(new String[size]);
            this.string = EncodingTools.toString(this);
        }

        public Object get(int index) {
            return this.schemes[index];
        }

        public int size() {
            return this.schemes.length;
        }

        public String toString() {
            return this.string;
        }

        public String toString(String encoding) throws UnsupportedEncodingException {
            StringBuffer buffer = new StringBuffer();
            for (int x = 0; x < this.schemes.length; ++x) {
                buffer.append(':');
                buffer.append(EncodingTools.urlEncode(this.schemes[x], encoding));
            }
            return buffer.substring(1);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Schemes) {
                return this.string.equals(((Schemes)object).string);
            }
            return false;
        }
    }
}

