/*
 * Decompiled with CFR 0.152.
 */
package it.could.util.http;

import it.could.util.StreamTools;
import it.could.util.StringTools;
import it.could.util.http.HttpClient;
import it.could.util.location.Location;
import it.could.util.location.Path;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebDavClient {
    private Resource resource;
    private Map children;

    public WebDavClient(Location location) throws NullPointerException, IOException {
        if (location == null) {
            throw new NullPointerException("Null location");
        }
        this.reload(location);
    }

    public WebDavClient refresh() throws IOException {
        this.reload(this.resource.location);
        return this;
    }

    public InputStream get(String child) throws NullPointerException, IOException {
        if (child == null) {
            throw new NullPointerException("Null child");
        }
        if (!this.isCollection(child)) {
            Location location = this.getLocation(child);
            HttpClient client = new HttpClient(location);
            client.setAcceptableStatus(200).connect("GET");
            return client.getResponseStream();
        }
        throw new IOException("Child \"" + child + "\" is a collection");
    }

    public WebDavClient delete(String child) throws NullPointerException, IOException {
        if (child == null) {
            throw new NullPointerException("Null child");
        }
        HttpClient client = new HttpClient(this.getLocation(child));
        client.setAcceptableStatus(204).connect("DELETE").disconnect();
        return this.refresh();
    }

    public WebDavClient mkcol(String child) throws NullPointerException, IOException {
        if (child == null) {
            throw new NullPointerException("Null child");
        }
        if (this.hasChild(child)) {
            throw new IOException("Child \"" + child + "\" already exists");
        }
        Location location = this.resource.location.resolve(child);
        HttpClient client = new HttpClient(location);
        client.setAcceptableStatus(201).connect("MKCOL").disconnect();
        return this.refresh();
    }

    public OutputStream put(final String child) throws NullPointerException {
        if (child == null) {
            throw new NullPointerException("Null child");
        }
        final WebDavClient client = this;
        return new ByteArrayOutputStream(){
            private boolean closed = false;

            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.flush();
                OutputStream output = client.put(child, this.buf.length);
                output.write(this.buf);
                output.flush();
                output.close();
            }

            protected void finalize() throws Throwable {
                this.closed = true;
                super.finalize();
            }
        };
    }

    public OutputStream put(String child, long length) throws NullPointerException, IOException {
        if (child == null) {
            throw new NullPointerException("Null child");
        }
        if (this.hasChild(child)) {
            this.delete(child);
        }
        Location location = this.resource.location.resolve(child);
        HttpClient client = new HttpClient(location);
        client.setAcceptableStatuses(new int[]{201, 204});
        client.connect("PUT", length);
        final WebDavClient webdav = this;
        return new BufferedOutputStream(client.getRequestStream()){
            boolean closed = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    super.close();
                }
                finally {
                    this.closed = true;
                    webdav.refresh();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    this.close();
                }
                finally {
                    super.finalize();
                }
            }
        };
    }

    public WebDavClient open(String child) throws NullPointerException, IOException {
        if (child == null) {
            throw new NullPointerException("Null child");
        }
        if (".".equals(child)) {
            return this.refresh();
        }
        if ("..".equals(child)) {
            return this.parent();
        }
        if (this.resource.collection) {
            Location loc = this.getLocation().resolve(this.getLocation(child));
            return new WebDavClient(loc);
        }
        throw new IOException("Child \"" + child + "\" is not a collection");
    }

    public WebDavClient parent() throws IOException {
        Location location = this.resource.location.resolve("..");
        return new WebDavClient(location);
    }

    public Iterator iterator() {
        return this.children.keySet().iterator();
    }

    public boolean hasChild(String child) {
        return this.children.containsKey(child);
    }

    public Location getLocation() {
        return this.resource.location;
    }

    public long getContentLength() {
        return this.resource.contentLength;
    }

    public String getContentType() {
        return this.resource.contentType;
    }

    public Date getLastModified() {
        return this.resource.lastModified;
    }

    public Date getCreationDate() {
        return this.resource.creationDate;
    }

    public Location getLocation(String child) throws IOException {
        Location location = this.getResource(child).location;
        return this.resource.location.resolve(location);
    }

    public boolean isCollection(String child) throws IOException {
        return this.getResource(child).collection;
    }

    public long getContentLength(String child) throws IOException {
        return this.getResource(child).contentLength;
    }

    public String getContentType(String child) throws IOException {
        return this.getResource(child).contentType;
    }

    public Date getLastModified(String child) throws IOException {
        return this.getResource(child).lastModified;
    }

    public Date getCreationDate(String child) throws IOException {
        return this.getResource(child).creationDate;
    }

    private Resource getResource(String child) throws IOException {
        if (child == null) {
            throw new NullPointerException();
        }
        Resource resource = (Resource)this.children.get(child);
        if (resource == null) {
            throw new IOException("Not found: " + child);
        }
        return resource;
    }

    private void reload(Location location) throws IOException {
        location = this.options(location);
        Iterator iterator = this.propfind(location).iterator();
        HashMap<String, Resource> children = new HashMap<String, Resource>();
        while (iterator.hasNext()) {
            Path.Element element;
            Resource resource = (Resource)iterator.next();
            Path path = resource.location.getPath();
            if (path.size() == 0) {
                resource.location = location.resolve(resource.location);
                this.resource = resource;
                continue;
            }
            if (path.size() != 1 || "..".equals((element = (Path.Element)path.get(0)).getName())) continue;
            children.put(element.toString(), resource);
        }
        if (this.resource == null) {
            throw new IOException("Current resource not returned in PROOPFIND");
        }
        this.children = Collections.unmodifiableMap(children);
    }

    private Location options(Location location) throws IOException {
        HttpClient client = new HttpClient(location);
        client.setAcceptableStatus(200).connect("OPTIONS", true).disconnect();
        List davHeader = client.getResponseHeaderValues("dav");
        if (davHeader == null) {
            throw new IOException("Server did not respond with a DAV header");
        }
        Iterator iterator = davHeader.iterator();
        boolean foundLevel1 = false;
        block0: while (iterator.hasNext() && !foundLevel1) {
            String value = (String)iterator.next();
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                if (!"1".equals(tokenizer.nextToken().trim())) continue;
                foundLevel1 = true;
                continue block0;
            }
        }
        if (foundLevel1) {
            return client.getLocation();
        }
        throw new IOException("Server doesn't support DAV Level 1");
    }

    private List propfind(Location location) throws IOException {
        HttpClient client = new HttpClient(location);
        client.addRequestHeader("Depth", "1");
        client.setAcceptableStatus(207).connect("PROPFIND", true);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            String systemId = location.toString();
            InputSource source = new InputSource(systemId);
            Handler handler = new Handler(location);
            source.setByteStream(client.getResponseStream());
            parser.parse(source, (DefaultHandler)handler);
            List list = handler.list;
            return list;
        }
        catch (ParserConfigurationException exception) {
            IOException throwable = new IOException("Error creating XML parser");
            throw (IOException)throwable.initCause(exception);
        }
        catch (SAXException exception) {
            IOException throwable = new IOException("Error creating XML parser");
            throw (IOException)throwable.initCause(exception);
        }
        finally {
            client.disconnect();
        }
    }

    public static void main(String[] args) throws IOException {
        InputStreamReader r = new InputStreamReader(System.in);
        BufferedReader in = new BufferedReader(r);
        WebDavClient client = new WebDavClient(Location.parse(args[0]));
        block2: while (true) {
            try {
                while (true) {
                    long bytes;
                    OutputStream output;
                    System.out.print("[" + client.getLocation() + "] -> ");
                    args = WebDavClient.parse(in.readLine());
                    if (args == null) break block2;
                    if (args[0].equals("list")) {
                        if (args[1] == null) {
                            WebDavClient.list(client, System.out);
                            continue;
                        }
                        WebDavClient.list(client.open(args[1]), System.out);
                        continue;
                    }
                    if (args[0].equals("refresh")) {
                        client = client.refresh();
                        continue;
                    }
                    if (args[0].equals("get")) {
                        if (args[1] != null) {
                            InputStream input = client.get(args[1]);
                            File file = new File(args[2]).getCanonicalFile();
                            output = new FileOutputStream(file);
                            bytes = StreamTools.copy(input, output);
                            System.out.println("Fetched child \"" + args[1] + "\" to file \"" + file + "\" (" + bytes + " bytes)");
                            continue;
                        }
                        System.out.print("Can't \"get\" null");
                        continue;
                    }
                    if (args[0].equals("put")) {
                        if (args[1] != null) {
                            File file = new File(args[1]).getCanonicalFile();
                            FileInputStream input = new FileInputStream(file);
                            output = client.put(args[2], file.length());
                            bytes = StreamTools.copy(input, output);
                            System.out.println("Uploaded file \"" + file + "\" to child \"" + args[2] + "\" (" + bytes + " bytes)");
                            continue;
                        }
                        System.out.print("Can't \"put\" null");
                        continue;
                    }
                    if (args[0].equals("mkcol")) {
                        if (args[1] != null) {
                            client.mkcol(args[1]);
                            System.out.println("Created \"" + args[1] + "\"");
                            continue;
                        }
                        System.out.print("Can't \"mkcol\" null");
                        continue;
                    }
                    if (args[0].equals("delete")) {
                        if (args[1] != null) {
                            client.delete(args[1]);
                            System.out.println("Deleted \"" + args[1] + "\"");
                            continue;
                        }
                        System.out.print("Can't \"delete\" null");
                        continue;
                    }
                    if (args[0].equals("cd")) {
                        if (args[1] != null) {
                            client = client.open(args[1]);
                            continue;
                        }
                        System.out.print("Can't \"cd\" to null");
                        continue;
                    }
                    if (args[0].equals("quit")) break block2;
                    System.out.print("Invalid command \"" + args[0] + "\". ");
                    System.out.println("Valid commands are:");
                    System.out.println(" - \"list\"    list the children child");
                    System.out.println(" - \"get\"     fetch the specified child");
                    System.out.println(" - \"put\"     put the specified child");
                    System.out.println(" - \"mkcol\"   create a collection");
                    System.out.println(" - \"delete\"  delete a child");
                    System.out.println(" - \"put\"     put the specified resource");
                    System.out.println(" - \"cd\"      change the location");
                    System.out.println(" - \"refresh\" refresh this location");
                    System.out.println(" - \"quit\"    quit this application");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                continue;
            }
            break;
        }
        System.err.println();
    }

    private static String[] parse(String line) {
        if (line == null) {
            return null;
        }
        String[] array = new String[3];
        StringTokenizer tokenizer = new StringTokenizer(line);
        int offset = 0;
        while (tokenizer.hasMoreTokens() && offset < 3) {
            array[offset++] = tokenizer.nextToken();
        }
        if (array[0] == null) {
            return null;
        }
        if (array[2] == null) {
            array[2] = array[1];
        }
        return array;
    }

    private static void list(WebDavClient client, PrintStream out) throws IOException {
        out.print("C | ");
        out.print("CONTENT TYPE    | ");
        out.print("CREATED             | ");
        out.print("MODIFIED            | ");
        out.print("SIZE       | ");
        out.println("NAME ");
        Iterator iterator = client.iterator();
        while (iterator.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            String child = (String)iterator.next();
            if (client.isCollection(child)) {
                buffer.append("* | ");
            } else {
                buffer.append("  | ");
            }
            WebDavClient.format(buffer, client.getContentType(child), 15).append(" | ");
            WebDavClient.format(buffer, client.getCreationDate(child), 19).append(" | ");
            WebDavClient.format(buffer, client.getLastModified(child), 19).append(" | ");
            WebDavClient.format(buffer, client.getContentLength(child), 10).append(" | ");
            out.println(buffer.append(child));
        }
    }

    private static StringBuffer format(StringBuffer buf, long num, int len) {
        String data = num < 0L ? "" : Long.toString(num);
        int spaces = len - data.length();
        for (int x = 0; x < spaces; ++x) {
            buf.append(' ');
        }
        buf.append(data);
        return buf;
    }

    private static StringBuffer format(StringBuffer buf, Object obj, int len) {
        String string;
        if (obj == null) {
            string = "[null]";
        } else if (obj instanceof Date) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            string = f.format((Date)obj);
        } else {
            string = obj.toString();
        }
        StringBuffer buffer = new StringBuffer(string);
        for (int x = string.length(); x < len; ++x) {
            buffer.append(' ');
        }
        return buf.append(buffer.substring(0, len));
    }

    private static class Resource {
        private Location location = null;
        private boolean collection = false;
        private long contentLength = -1L;
        private String contentType = null;
        private Date lastModified = null;
        private Date creationDate = null;

        private Resource() {
        }
    }

    private static final class Handler
    extends DefaultHandler {
        private static final String RESPONSE_PATH = "/multistatus/response";
        private static final String HREF_PATH = "/multistatus/response/href";
        private static final String COLLECTION_PATH = "/multistatus/response/propstat/prop/resourcetype/collection";
        private static final String GETCONTENTTYPE_PATH = "/multistatus/response/propstat/prop/getcontenttype";
        private static final String GETLASTMODIFIED_PATH = "/multistatus/response/propstat/prop/getlastmodified";
        private static final String GETCONTENTLENGTH_PATH = "/multistatus/response/propstat/prop/getcontentlength";
        private static final String CREATIONDATE_PATH = "/multistatus/response/propstat/prop/creationdate";
        private final Location base;
        private final List list = new ArrayList();
        private Resource rsrc = null;
        private StringBuffer buff = null;
        private Stack stack = new Stack();

        private Handler(Location location) {
            this.base = location;
        }

        private String pushPath(String path) {
            this.stack.push(path.toLowerCase());
            StringBuffer buffer = new StringBuffer();
            for (int x = 0; x < this.stack.size(); ++x) {
                buffer.append('/').append(this.stack.get(x));
            }
            return buffer.toString();
        }

        private String popPath(String path) throws SAXException {
            StringBuffer buffer = new StringBuffer();
            String last = (String)this.stack.pop();
            if (path.toLowerCase().equals(last)) {
                for (int x = 0; x < this.stack.size(); ++x) {
                    buffer.append('/').append(this.stack.get(x));
                }
                return buffer.append('/').append(last).toString();
            }
            throw new SAXException("Tag <" + path + "/> unbalanced at path \"" + this.pushPath(last) + "\"");
        }

        public void startElement(String uri, String l, String q, Attributes a) throws SAXException {
            if (!"DAV:".equals(uri.toUpperCase())) {
                return;
            }
            String path = this.pushPath(l);
            if (RESPONSE_PATH.equals(path)) {
                this.rsrc = new Resource();
            } else if (COLLECTION_PATH.equals(path)) {
                if (this.rsrc != null) {
                    this.rsrc.collection = true;
                }
            } else if (GETCONTENTTYPE_PATH.equals(path) || GETLASTMODIFIED_PATH.equals(path) || GETCONTENTLENGTH_PATH.equals(path) || CREATIONDATE_PATH.equals(path) || HREF_PATH.equals(path)) {
                this.buff = new StringBuffer();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String uri, String l, String q) throws SAXException {
            if (!"DAV:".equals(uri.toUpperCase())) {
                return;
            }
            String path = this.popPath(l);
            String data = this.resetBuffer();
            if (RESPONSE_PATH.equals(path)) {
                if (this.rsrc == null) return;
                if (this.rsrc.location == null) throw new SAXException("Null location for resource");
                if (this.rsrc.location.isAbsolute()) {
                    String z = this.rsrc.location.toString();
                    throw new SAXException("Unresolved location " + z);
                }
                this.list.add(this.rsrc);
                return;
            } else {
                if (HREF_PATH.equals(path)) {
                    if (this.rsrc == null) return;
                    try {
                        Location resolved = this.base.resolve(data);
                        this.rsrc.location = this.base.relativize(resolved);
                        if (this.rsrc.location.isRelative()) return;
                        throw new SAXException("Unable to relativize location " + this.rsrc.location);
                    }
                    catch (MalformedURLException exception) {
                        String msg = "Unable to resolve URL \"" + data + "\"";
                        SAXException throwable = new SAXException(msg, exception);
                        throw (SAXException)throwable.initCause(exception);
                    }
                }
                if (CREATIONDATE_PATH.equals(path)) {
                    if (this.rsrc == null) return;
                    this.rsrc.creationDate = StringTools.parseIsoDate(data);
                    return;
                } else if (GETCONTENTTYPE_PATH.equals(path)) {
                    if (this.rsrc == null) return;
                    this.rsrc.contentType = data;
                    return;
                } else if (GETLASTMODIFIED_PATH.equals(path)) {
                    if (this.rsrc == null) return;
                    this.rsrc.lastModified = StringTools.parseHttpDate(data);
                    return;
                } else {
                    Long length;
                    if (!GETCONTENTLENGTH_PATH.equals(path) || this.rsrc == null || (length = StringTools.parseNumber(data)) == null) return;
                    this.rsrc.contentLength = length;
                }
            }
        }

        public void characters(char[] buffer, int offset, int length) {
            if (this.buff != null) {
                this.buff.append(buffer, offset, length);
            }
        }

        private String resetBuffer() {
            if (this.buff == null) {
                return null;
            }
            if (this.buff.length() == 0) {
                this.buff = null;
                return null;
            }
            String value = this.buff.toString();
            this.buff = null;
            return value;
        }
    }
}

