/*
 * Decompiled with CFR 0.152.
 */
package it.could.util.http;

import it.could.util.encoding.EncodingTools;
import it.could.util.location.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpClient {
    public static final String DEFAULT_METHOD = "GET";
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] HTTP = new byte[]{32, 72, 84, 84, 80, 47, 49, 46, 48, 13, 10};
    private final byte[] buffer = new byte[4096];
    private final Map requestHeaders = new HashMap();
    private final Map responseHeaders = new HashMap();
    private Location location;
    private Status status = null;
    private int[] acceptable = null;
    private Input xinput = null;
    private Output xoutput = null;
    private Socket xsocket = null;

    public HttpClient(String location) throws MalformedURLException {
        this.location = Location.parse(location);
    }

    public HttpClient(String location, String encoding) throws MalformedURLException, UnsupportedEncodingException {
        this.location = Location.parse(location, encoding);
    }

    public HttpClient(Location location) {
        if (location == null) {
            throw new NullPointerException("Null location");
        }
        if (!location.isAbsolute()) {
            throw new IllegalArgumentException("Relative location supplied");
        }
        if (!"http".equals(location.getSchemes().toString())) {
            throw new IllegalArgumentException("Scheme is not HTTP");
        }
        this.location = location;
    }

    public HttpClient setAcceptableStatus(int status) {
        return this.setAcceptableStatuses(new int[]{status});
    }

    public HttpClient setAcceptableStatuses(int[] statuses) {
        if (statuses == null) {
            this.acceptable = null;
            return this;
        }
        for (int x = 0; x < statuses.length; ++x) {
            int status = statuses[x];
            if (status >= 100 && status <= 599) continue;
            throw new IllegalArgumentException("Wrong status " + status);
        }
        this.acceptable = statuses;
        return this;
    }

    public HttpClient connect() throws IOException {
        return this.connect(DEFAULT_METHOD, true, 0L);
    }

    public HttpClient connect(long contentLength) throws IOException {
        return this.connect(DEFAULT_METHOD, false, contentLength);
    }

    public HttpClient connect(boolean followRedirects) throws IOException {
        return this.connect(DEFAULT_METHOD, followRedirects, 0L);
    }

    public HttpClient connect(String method) throws IOException {
        return this.connect(method, true, 0L);
    }

    public HttpClient connect(String method, long contentLength) throws IOException {
        return this.connect(method, false, contentLength);
    }

    public HttpClient connect(String method, boolean followRedirects) throws IOException {
        return this.connect(method, followRedirects, 0L);
    }

    public HttpClient disconnect() throws IOException {
        return this.disconnect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient disconnect(boolean reset) throws IOException {
        Socket socket = this.xsocket;
        if (socket != null) {
            try {
                this.xsocket = null;
                if (this.xinput != null) {
                    if (!this.xinput.closed) {
                        this.xinput.close();
                    }
                    this.xinput = null;
                }
                if (this.xoutput != null) {
                    if (!this.xoutput.closed) {
                        this.xoutput.close();
                    }
                    this.xoutput = null;
                }
            }
            finally {
                socket.close();
            }
        }
        if (reset) {
            this.requestHeaders.clear();
            this.responseHeaders.clear();
            this.status = null;
            this.acceptable = null;
        }
        return this;
    }

    private HttpClient connect(String method, boolean redirect, long length) throws IOException {
        InputStream in;
        Socket sock;
        if (this.xsocket != null) {
            throw new IllegalStateException("Already connected");
        }
        if (length < 0L) {
            throw new IOException("Negative length");
        }
        if (length > 0L && redirect) {
            throw new InternalError("Can't follow redirects and write request");
        }
        String userinfo = this.location.getAuthority().getUserInfo();
        if (userinfo != null) {
            String encoded = EncodingTools.base64Encode(userinfo);
            this.addRequestHeader("Authorization", "Basic " + encoded);
        }
        method = method.toUpperCase();
        this.addRequestHeader("Connection", "close", false);
        this.addRequestHeader("Content-Length", Long.toString(length), false);
        int redirs = 20;
        while (true) {
            String location;
            if (--redirs < 0) {
                throw new IOException("Too many redirections");
            }
            Location.Authority auth = this.location.getAuthority();
            String host = auth.getHost();
            int port = auth.getPort() < 0 ? 80 : auth.getPort();
            this.addRequestHeader("Host", host + ":" + port, false);
            sock = new Socket(auth.getHost(), port);
            in = sock.getInputStream();
            OutputStream out = sock.getOutputStream();
            out.write((method + " ").getBytes("US-ASCII"));
            out.write(this.location.getPath().toString().getBytes("US-ASCII"));
            out.write(HTTP);
            Iterator headers = this.requestHeaders.values().iterator();
            while (headers.hasNext()) {
                RequestHeader header = (RequestHeader)headers.next();
                Iterator values = header.values.iterator();
                while (values.hasNext()) {
                    out.write(header.name);
                    out.write((byte[])values.next());
                }
            }
            out.write(CRLF);
            out.flush();
            if (length > 0L) {
                this.xsocket = sock;
                this.xoutput = new Output(this, in, out, length);
                this.xinput = null;
                return this;
            }
            this.readStatusLine(in);
            this.readHeaders(in);
            int code = this.status.status;
            if (!redirect || code != 301 && code != 302 && code != 307 || (location = this.getResponseHeader("Location")) == null) break;
            in.close();
            out.close();
            sock.close();
            this.location = this.location.resolve(location);
        }
        this.verify();
        String len = this.getResponseHeader("Content-Length");
        long bytesLength = -1L;
        if (len != null) {
            try {
                bytesLength = Long.parseLong(len);
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        this.xsocket = sock;
        this.xoutput = null;
        this.xinput = new Input(this, in, bytesLength);
        return this;
    }

    private void verify() throws IOException {
        if (this.acceptable != null) {
            boolean accepted = false;
            for (int x = 0; x < this.acceptable.length; ++x) {
                if (this.status.status != this.acceptable[x]) continue;
                accepted = true;
                break;
            }
            if (!accepted) {
                this.disconnect();
                throw new IOException("Connection to " + this.location + " returned unacceptable status " + this.status.status + " (" + this.status.message + ")");
            }
        }
    }

    public InputStream getResponseStream() throws IllegalStateException {
        if (this.xsocket == null) {
            throw new IllegalStateException("Connection not available");
        }
        if (this.xoutput != null && this.xoutput.remaining != 0L) {
            throw new IllegalStateException("Request body not fully written");
        }
        return this.xinput;
    }

    public OutputStream getRequestStream() throws IllegalStateException {
        if (this.xsocket == null) {
            throw new IllegalStateException("Connection not available");
        }
        if (this.xoutput == null) {
            throw new IllegalStateException("No request body to write to");
        }
        return this.xoutput;
    }

    public Location getLocation() {
        return this.location;
    }

    public HttpClient addRequestHeader(String name, String value) {
        return this.addRequestHeader(name, value, false);
    }

    public HttpClient addRequestHeader(String name, String value, boolean appendValue) {
        String key = name.toLowerCase();
        try {
            RequestHeader header;
            if (appendValue) {
                header = (RequestHeader)this.requestHeaders.get(key);
                if (header == null) {
                    header = new RequestHeader(name);
                    this.requestHeaders.put(key, header);
                }
            } else {
                header = new RequestHeader(name);
                this.requestHeaders.put(key, header);
            }
            header.values.add((value + "\r\n").getBytes("ISO-8859-1"));
            return this;
        }
        catch (UnsupportedEncodingException exception) {
            InternalError error = new InternalError("Standard encoding not supported");
            throw (InternalError)error.initCause(exception);
        }
    }

    public HttpClient removeRequestHeader(String name) {
        String key = name.toLowerCase();
        this.requestHeaders.remove(key);
        return this;
    }

    public HttpClient removeRequestHeaders() {
        this.requestHeaders.clear();
        return this;
    }

    public String getResponseHeader(String name) {
        String key = name.toLowerCase();
        ResponseHeader header = (ResponseHeader)this.responseHeaders.get(key);
        if (header == null) {
            return null;
        }
        return (String)header.values.get(0);
    }

    public List getResponseHeaderValues(String name) {
        String key = name.toLowerCase();
        ResponseHeader header = (ResponseHeader)this.responseHeaders.get(key);
        if (header == null) {
            return null;
        }
        return Collections.unmodifiableList(header.values);
    }

    public Iterator getResponseHeaderNames() {
        final Iterator iterator = this.responseHeaders.values().iterator();
        return new Iterator(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return ((ResponseHeader)iterator.next()).name;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getResponseProtocol() {
        if (this.status == null) {
            throw new IllegalStateException();
        }
        return this.status.protocol;
    }

    public int getResponseStatus() {
        if (this.status == null) {
            throw new IllegalStateException();
        }
        return this.status.status;
    }

    public String getResponseMessage() {
        if (this.status == null) {
            throw new IllegalStateException();
        }
        return this.status.message;
    }

    private byte[] readLine(InputStream input) throws IOException {
        int b;
        int x = 0;
        while ((b = input.read()) != -1 && b != 10 && x != this.buffer.length) {
            this.buffer[x++] = (byte)b;
        }
        if (x > 0 && this.buffer[x - 1] == 13) {
            --x;
        }
        byte[] array = new byte[x];
        System.arraycopy(this.buffer, 0, array, 0, x);
        return array;
    }

    private void readStatusLine(InputStream input) throws IOException {
        byte[] line = this.readLine(input);
        byte[] buff = new byte[line.length];
        String[] comp = new String[3];
        int lpos = 0;
        int bpos = 0;
        int cpos = 0;
        boolean spc = true;
        while (lpos < line.length) {
            byte b = line[lpos++];
            if (spc) {
                if (b == 9 || b == 32) continue;
                buff[bpos++] = b;
                if (cpos == 2) break;
                spc = false;
                continue;
            }
            if (b == 9 || b == 32) {
                comp[cpos++] = new String(buff, 0, bpos, "US-ASCII");
                bpos = 0;
                spc = true;
                continue;
            }
            buff[bpos++] = b;
        }
        while (lpos < line.length) {
            buff[bpos++] = line[lpos++];
        }
        if (bpos > 0) {
            comp[cpos++] = new String(buff, 0, bpos, "US-ASCII");
        }
        for (int x = cpos; x < 3; ++x) {
            comp[x] = "";
        }
        this.status = new Status(comp[0], comp[1], comp[2]);
    }

    private void readHeaders(InputStream input) throws IOException {
        byte[] array;
        this.responseHeaders.clear();
        while ((array = this.readLine(input)).length != 0) {
            int pos = -1;
            while (pos < array.length && array[++pos] != 58) {
            }
            if (pos == 0 || pos == array.length - 1) continue;
            int o = pos + 1;
            int l = array.length - o;
            String name = new String(array, 0, pos, "US-ASCII").trim();
            String value = new String(array, o, l, "ISO-8859-1").trim();
            if (name.length() == 0 || value.length() == 0) continue;
            String key = name.toLowerCase();
            ResponseHeader hdr = (ResponseHeader)this.responseHeaders.get(key);
            if (hdr == null) {
                hdr = new ResponseHeader(name);
                this.responseHeaders.put(key, hdr);
            }
            hdr.values.add(value);
        }
    }

    public static final void main(String[] args) {
        try {
            HttpClient c = new HttpClient(args[0]).connect();
            InputStream i = c.getResponseStream();
            int b = i.read();
            while (b >= 0) {
                System.out.write(b);
                b = i.read();
            }
            c.disconnect();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    private static final class Input
    extends InputStream {
        private final InputStream input;
        private final HttpClient client;
        private long remaining;
        private boolean closed;

        private Input(HttpClient client, InputStream input, long remaining) {
            if (input == null) {
                throw new NullPointerException();
            }
            if (client == null) {
                throw new NullPointerException();
            }
            this.remaining = remaining < 0L ? Long.MAX_VALUE : remaining;
            this.client = client;
            this.input = input;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            int n;
            block3: {
                if (this.remaining < 1L) {
                    return -1;
                }
                try {
                    n = this.input.read();
                    Object var3_2 = null;
                    --this.remaining;
                    if (this.remaining >= 1L) break block3;
                }
                catch (Throwable throwable) {
                    block4: {
                        Object var3_3 = null;
                        --this.remaining;
                        if (this.remaining >= 1L) break block4;
                        this.close();
                    }
                    throw throwable;
                }
                this.close();
            }
            return n;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.remaining <= 0L) {
                return -1;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            int count = 0;
            try {
                count = this.input.read(buf, off, len);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.remaining -= (long)count;
                if (this.remaining < 1L) {
                    this.close();
                }
                throw throwable;
            }
            this.remaining -= (long)count;
            if (this.remaining < 1L) {
                this.close();
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long skip(long n) throws IOException {
            if (this.remaining <= 0L) {
                return -1L;
            }
            if (n > this.remaining) {
                n = this.remaining;
            }
            long count = 0L;
            try {
                count = this.input.skip(n);
                Object var6_3 = null;
                this.remaining -= count;
                if (this.remaining >= 1L) return count;
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                this.remaining -= count;
                if (this.remaining >= 1L) throw throwable;
                this.close();
                throw throwable;
            }
            this.close();
            return count;
        }

        public int available() throws IOException {
            int count = this.input.available();
            if ((long)count < this.remaining) {
                return count;
            }
            return (int)this.remaining;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.input.close();
            }
            finally {
                this.client.disconnect();
            }
        }

        public void mark(int readlimit) {
            this.input.mark(readlimit);
        }

        public void reset() throws IOException {
            this.input.reset();
        }

        public boolean markSupported() {
            return this.input.markSupported();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class Output
    extends OutputStream {
        private final OutputStream output;
        private final InputStream input;
        private final HttpClient client;
        private long remaining;
        private boolean closed;

        private Output(HttpClient client, InputStream input, OutputStream output, long remaining) {
            if (input == null) {
                throw new NullPointerException();
            }
            if (output == null) {
                throw new NullPointerException();
            }
            if (client == null) {
                throw new NullPointerException();
            }
            this.remaining = remaining;
            this.client = client;
            this.output = output;
            this.input = input;
        }

        public void write(byte[] buf) throws IOException {
            this.write(buf, 0, buf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int off, int len) throws IOException {
            if ((long)len > this.remaining) {
                throw new IOException("Too much data to write");
            }
            try {
                this.output.write(buf, off, len);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.remaining -= (long)len;
                if (this.remaining < 1L) {
                    this.close();
                }
                throw throwable;
            }
            this.remaining -= (long)len;
            if (this.remaining < 1L) {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(int b) throws IOException {
            if (this.remaining < 1L) {
                throw new IOException("Too much data to write");
            }
            try {
                this.output.write(b);
                Object var3_2 = null;
                --this.remaining;
                if (this.remaining >= 1L) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                --this.remaining;
                if (this.remaining >= 1L) throw throwable;
                this.close();
                throw throwable;
            }
            this.close();
        }

        public void flush() throws IOException {
            this.output.flush();
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.remaining > 0L) {
                throw new IOException(this.remaining + " bytes left to write");
            }
            this.closed = true;
            this.output.flush();
            this.client.readStatusLine(this.input);
            this.client.readHeaders(this.input);
            this.client.verify();
            String slen = this.client.getResponseHeader("Content-Length");
            long blen = -1L;
            if (slen != null) {
                try {
                    blen = Long.parseLong(slen);
                }
                catch (NumberFormatException exception) {
                    // empty catch block
                }
            }
            this.client.xoutput = null;
            this.client.xinput = new Input(this.client, this.input, blen);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class ResponseHeader {
        private final String name;
        private final List values;

        private ResponseHeader(String name) throws UnsupportedEncodingException {
            this.name = name;
            this.values = new ArrayList();
        }
    }

    private static final class RequestHeader {
        private final byte[] name;
        private final List values;

        private RequestHeader(String name) throws UnsupportedEncodingException {
            this.name = (name + ": ").getBytes("US-ASCII");
            this.values = new ArrayList();
        }
    }

    private static final class Status {
        private final String protocol;
        private final int status;
        private final String message;

        private Status(String protocol, String status, String message) throws IOException {
            if (!"HTTP/1.0".equals(protocol) && !"HTTP/1.1".equals(protocol)) {
                throw new IOException("Unknown protocol \"" + protocol + "\"");
            }
            this.protocol = protocol;
            try {
                this.status = Integer.parseInt(status);
                if (this.status < 100 || this.status > 599) {
                    throw new IOException("Invalid status \"" + status + "\"");
                }
            }
            catch (RuntimeException exception) {
                String error = "Can't parse status \"" + status + "\"";
                IOException throwable = new IOException(error);
                throw (IOException)throwable.initCause(exception);
            }
            this.message = "".equals(message) ? "No message" : EncodingTools.urlDecode(message, "ISO-8859-1");
        }
    }
}

