/*
 * Decompiled with CFR 0.152.
 */
package it.could.util.encoding;

import it.could.util.encoding.Encodable;
import it.could.util.encoding.EncodingAware;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class EncodingTools
implements EncodingAware {
    private static final char[] ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};

    private EncodingTools() {
    }

    public static String toString(Encodable encodable) {
        try {
            return encodable.toString("UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Default encoding \"UTF-8\" not supported by the platform";
            InternalError error = new InternalError("Default encoding \"UTF-8\" not supported by the platform");
            throw (InternalError)error.initCause(exception);
        }
    }

    public static String urlEncode(String source, String encoding) throws UnsupportedEncodingException {
        if (source == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return URLEncoder.encode(source, encoding);
    }

    public static String urlEncode(String source) {
        if (source == null) {
            return null;
        }
        try {
            return URLEncoder.encode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public static String urlDecode(String source, String encoding) throws UnsupportedEncodingException {
        if (source == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return URLDecoder.decode(source, encoding);
    }

    public static String urlDecode(String source) {
        if (source == null) {
            return null;
        }
        try {
            return URLDecoder.decode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public static final String base64Encode(String string, String encoding) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        byte[] bsrc = string.getBytes(encoding);
        char[] bdst = new char[(bsrc.length + 2) / 3 * 4];
        int psrc = -1;
        int pdst = 0;
        int temp = 0;
        while ((psrc += 3) < bsrc.length) {
            temp = bsrc[psrc - 2] << 16 & 0xFF0000 | bsrc[psrc - 1] << 8 & 0xFF00 | bsrc[psrc] & 0xFF;
            bdst[pdst++] = ALPHABET[temp >> 18 & 0x3F];
            bdst[pdst++] = ALPHABET[temp >> 12 & 0x3F];
            bdst[pdst++] = ALPHABET[temp >> 6 & 0x3F];
            bdst[pdst++] = ALPHABET[temp & 0x3F];
        }
        switch (psrc - bsrc.length) {
            case 0: {
                temp = (bsrc[psrc - 2] & 0xFF) << 8 | bsrc[psrc - 1] & 0xFF;
                bdst[pdst++] = ALPHABET[temp >> 10 & 0x3F];
                bdst[pdst++] = ALPHABET[temp >> 4 & 0x3F];
                bdst[pdst++] = ALPHABET[temp << 2 & 0x3C];
                bdst[pdst++] = ALPHABET[64];
                break;
            }
            case 1: {
                temp = bsrc[psrc - 2] & 0xFF;
                bdst[pdst++] = ALPHABET[temp >> 2 & 0x3F];
                bdst[pdst++] = ALPHABET[temp << 4 & 0x30];
                bdst[pdst++] = ALPHABET[64];
                bdst[pdst++] = ALPHABET[64];
            }
        }
        return new String(bdst);
    }

    public static final String base64Encode(String string) {
        try {
            return EncodingTools.base64Encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public static final String base64Decode(String string, String encoding) throws UnsupportedEncodingException {
        char[] characters;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (((characters = string.toCharArray()).length & 3) != 0) {
            throw new IllegalArgumentException("Invalid length for the encoded string (" + characters.length + ")");
        }
        byte[] bytes = new byte[characters.length - (characters.length >> 2)];
        if (characters[characters.length - 4] == '=' || characters[characters.length - 3] == '=' || characters[characters.length - 2] == '=' && characters[characters.length - 1] != '=') {
            throw new IllegalArgumentException("Invalid pattern for last Base64 token in string to decode: " + characters[characters.length - 4] + characters[characters.length - 3] + characters[characters.length - 2] + characters[characters.length - 1]);
        }
        int coff = 0;
        int boff = 0;
        while (coff < characters.length) {
            boolean last = coff == characters.length - 4;
            int curr = EncodingTools.value(characters[coff], last) << 18 | EncodingTools.value(characters[coff + 1], last) << 12 | EncodingTools.value(characters[coff + 2], last) << 6 | EncodingTools.value(characters[coff + 3], last);
            bytes[boff + 2] = (byte)(curr & 0xFF);
            bytes[boff + 1] = (byte)(curr >> 8 & 0xFF);
            bytes[boff] = (byte)(curr >> 16 & 0xFF);
            coff += 4;
            boff += 3;
        }
        if (characters[coff - 1] == '=') {
            --boff;
        }
        if (characters[coff - 2] == '=') {
            --boff;
        }
        return new String(bytes, 0, boff, encoding);
    }

    public static final String base64Decode(String string) {
        try {
            return EncodingTools.base64Decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    private static final int value(char character, boolean last) {
        for (int x = 0; x < 64; ++x) {
            if (ALPHABET[x] != character) continue;
            return x;
        }
        if (last && character == ALPHABET[65]) {
            return 0;
        }
        String message = "Character \"" + character + "\" invalid";
        throw new IllegalArgumentException(message);
    }
}

