/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeSet;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;

public class Sentence2RDF {
    public Sentence sentence;
    public int inx;

    public Sentence2RDF(Sentence sentence, int inx) {
        this.sentence = sentence;
        this.inx = inx;
    }

    public String makeArgString(Map<Word, String> argMap) {
        if (argMap.isEmpty()) {
            return "[]";
        }
        TreeSet<Word> ts = new TreeSet<Word>(Word.WORD_LINEAR_ORDER_COMPARATOR);
        ts.addAll(argMap.keySet());
        String tmp = "";
        for (Word word : ts) {
            tmp = tmp + "\t\t\t[gstruct:id " + word.getIdx() + " ; ";
            tmp = tmp + " gstruct:argtype \"" + argMap.get(word) + "\"],\n";
        }
        tmp = tmp.replaceAll(",\n$", "");
        return tmp;
    }

    public void printRDF(PrintStream out) {
        String tmp;
        int i;
        out.println("gstruct:sentence_" + this.inx + "\trdf:type\t" + "gstruct:Sentence ;");
        out.println("\tgstruct:inx\t" + this.inx + " ;");
        out.println("\tgstruct:words");
        for (i = 1; i < this.sentence.size(); ++i) {
            String lemma = ((Word)this.sentence.get(i)).getLemma();
            String pos = ((Word)this.sentence.get(i)).getPOS();
            tmp = "\t\t[";
            tmp = tmp + "gstruct:id " + i + " ; ";
            tmp = tmp + "gstruct:form \"" + ((Word)this.sentence.get(i)).getForm() + "\"" + " ; ";
            if (lemma != null && !lemma.equals("_")) {
                tmp = tmp + "gstruct:lemma \"" + lemma + "\"" + " ; ";
            }
            tmp = tmp + "gstruct:pos \"" + pos + "\"" + " ; ";
            if (pos != null && !pos.equals("_")) {
                tmp = tmp + "gstruct:head \"" + ((Word)this.sentence.get(i)).getHeadId() + "\"" + " ; ";
            }
            tmp = tmp + "gstruct:deprel \"" + ((Word)this.sentence.get(i)).getDeprel() + "\"";
            tmp = tmp + "]";
            if (i != this.sentence.size() - 1) {
                tmp = tmp + ",\n";
            }
            out.print(tmp);
        }
        if (this.sentence.getPredicates().isEmpty()) {
            out.println(".");
            return;
        }
        out.println(";");
        out.println("\tgstruct:predicates");
        for (i = 0; i < this.sentence.getPredicates().size(); ++i) {
            tmp = "\t\t[";
            tmp = tmp + "gstruct:id " + this.sentence.getPredicates().get(i).getIdx() + " ; ";
            tmp = tmp + "gstruct:predsense \"" + this.sentence.getPredicates().get(i).getSense() + "\"" + " ; ";
            tmp = tmp + "gstruct:args\n";
            tmp = tmp + this.makeArgString(this.sentence.getPredicates().get(i).getArgMap());
            tmp = tmp + "]";
            if (i != this.sentence.getPredicates().size() - 1) {
                tmp = tmp + ",\n";
            }
            out.print(tmp);
        }
        out.println(".");
    }

    public void printPrefix(PrintStream out) {
        out.println("@prefix gstruct: <http://cs.lth.se/ontologies/gstruct.owl#> .");
        out.println("@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .");
    }

    public static String sentence2RDF(Sentence s) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream((OutputStream)baos, true, "UTF8");
        Sentence2RDF s2r = new Sentence2RDF(s, 1);
        s2r.printPrefix(p);
        p.println();
        s2r.printRDF(p);
        p.close();
        return baos.toString("UTF8");
    }
}

