/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.preprocessor.tokenization;

import java.nio.charset.Charset;
import java.util.ArrayList;
import se.lth.cs.srl.preprocessor.tokenization.Tokenizer;
import se.lth.cs.srl.preprocessor.tokenization.exner.SwedishTokenizer;

public class ExnerSwedishTokenizer
implements Tokenizer {
    @Override
    public String[] tokenize(String sentence) {
        SwedishTokenizer swedishTokenizer = new SwedishTokenizer();
        ArrayList<String> tokens = swedishTokenizer.tokenize(sentence, Charset.forName("UTF-8"));
        String[] tok = new String[tokens.size() + 1];
        tok[0] = "<root>";
        int i = 1;
        for (String s : tokens) {
            tok[i++] = s;
        }
        return tok;
    }

    public static void main(String[] args) {
        String t1 = "En gul bil k\u00f6rde hundratusen mil.";
        String t2 = "Leonardos fullst\u00e4ndiga namn var Leonardo di ser Piero da Vinci.";
        String t3 = "Genom skattereformen inf\u00f6rs individuell beskattning (s\u00e4rbeskattning) av arbetsinkomster.";
        String t4 = "Det inneb\u00e4r bl.a. att endast en skatteskala kommer att finnas f\u00f6r ber\u00e4kning av statlig inkomstskatt.";
        String t5 = "B-inkomster som f\u00f6r makarna sammanlagt uppg\u00e5r till h\u00f6gst 2000kr skall dock betraktas som A-inkomst och allts\u00e5 beskattas individuellt";
        String t6 = "Grundavdraget blir 2500kr (=4500 minskat med 1/5 av 10000kr).";
        String[] tests = new String[]{t1, t2, t3, t4, t5, t6};
        ExnerSwedishTokenizer tokenizer = new ExnerSwedishTokenizer();
        for (String test : tests) {
            String[] tokens;
            for (String token : tokens = tokenizer.tokenize(test)) {
                System.out.println(token);
            }
            System.out.println();
        }
    }
}

