/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.pipeline;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import se.lth.cs.srl.SemanticRoleLabeler;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.PredicateReference;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.features.Feature;
import se.lth.cs.srl.features.FeatureFile;
import se.lth.cs.srl.features.FeatureGenerator;
import se.lth.cs.srl.features.FeatureSet;
import se.lth.cs.srl.options.LearnOptions;
import se.lth.cs.srl.pipeline.ArgumentClassifier;
import se.lth.cs.srl.pipeline.ArgumentIdentifier;
import se.lth.cs.srl.pipeline.PipelineStep;
import se.lth.cs.srl.pipeline.PredicateDisambiguator;
import se.lth.cs.srl.pipeline.PredicateIdentifier;
import se.lth.cs.srl.pipeline.Step;
import se.lth.cs.srl.util.BrownCluster;

public class Pipeline
extends SemanticRoleLabeler {
    private PredicateReference predicateReference;
    private List<String> argLabels;
    private FeatureGenerator fg;
    private Map<Step, FeatureSet> featureSets;
    List<PipelineStep> steps;

    private Pipeline(FeatureGenerator fg, Map<Step, FeatureSet> featureSets, Iterable<Sentence> sentences) {
        if (featureSets.containsKey((Object)Step.pd)) {
            this.predicateReference = new PredicateReference(featureSets.get((Object)((Object)Step.pd)).POSPrefixes);
        }
        if (featureSets.containsKey((Object)Step.ac)) {
            this.argLabels = new ArrayList<String>();
        }
        Pipeline.extractLabels(sentences, this.predicateReference, this.argLabels);
        this.fg = fg;
        this.featureSets = featureSets;
        this.setup(featureSets, this.predicateReference, this.argLabels);
    }

    private Pipeline(FeatureGenerator fg, PredicateReference predicateReference, List<String> argLabels, Map<Step, FeatureSet> featureSets) {
        this.predicateReference = predicateReference;
        this.argLabels = argLabels;
        this.fg = fg;
        this.featureSets = featureSets;
        this.setup(featureSets, predicateReference, argLabels);
    }

    private void setup(Map<Step, FeatureSet> featureSets, PredicateReference predicateReference, List<String> argLabels) {
        this.steps = new ArrayList<PipelineStep>();
        block6: for (Step step : Step.values()) {
            if (!featureSets.containsKey((Object)step)) continue;
            switch (step) {
                case pi: {
                    this.steps.add(new PredicateIdentifier(featureSets.get((Object)Step.pi)));
                    continue block6;
                }
                case pd: {
                    this.steps.add(new PredicateDisambiguator(featureSets.get((Object)Step.pd), predicateReference));
                    continue block6;
                }
                case ai: {
                    this.steps.add(new ArgumentIdentifier(featureSets.get((Object)Step.ai)));
                    continue block6;
                }
                case ac: {
                    this.steps.add(new ArgumentClassifier(featureSets.get((Object)Step.ac), argLabels));
                }
            }
        }
    }

    @Override
    protected void parse(Sentence s) {
        for (PipelineStep step : this.steps) {
            step.parse(s);
        }
    }

    public static void extractLabels(Iterable<Sentence> reader, PredicateReference predicateReference, List<String> argLabels) {
        if (predicateReference == null && argLabels == null) {
            return;
        }
        System.out.println("Extracting argument labels and predicate senses.");
        HashSet<String> argLabelSet = new HashSet<String>();
        for (Sentence s : reader) {
            for (Predicate p : s.getPredicates()) {
                if (predicateReference != null) {
                    predicateReference.extractSense(p);
                }
                if (argLabels == null) continue;
                argLabelSet.addAll(p.getArgMap().values());
            }
        }
        if (argLabels != null) {
            argLabels.addAll(argLabelSet);
        }
        if (predicateReference != null) {
            predicateReference.trim();
        }
    }

    private void train(Iterable<Sentence> sentences, ZipOutputStream zos) throws IOException {
        for (PipelineStep step : this.steps) {
            step.prepareLearning();
        }
        System.out.println("Extracting training instances from corpus.");
        int senCount = 0;
        for (Sentence s : sentences) {
            if (++senCount % 1000 == 0) {
                System.out.println("Processing sentence " + senCount);
            }
            for (PipelineStep step : this.steps) {
                step.extractInstances(s);
            }
        }
        for (PipelineStep step : this.steps) {
            step.done();
        }
        System.out.println("Starting training.");
        for (PipelineStep step : this.steps) {
            step.train();
        }
        if (zos != null) {
            System.out.println("Saving classifiers to model.");
            for (PipelineStep step : this.steps) {
                step.writeModels(zos);
            }
        }
    }

    public static Pipeline trainNewPipeline(Iterable<Sentence> sentences, FeatureGenerator fg, ZipOutputStream zos, Map<Step, FeatureSet> featureSets) throws IOException {
        Pipeline pipeline = new Pipeline(fg, featureSets, sentences);
        if (zos != null) {
            System.out.println("Writing various objects to model file.");
            for (Step s : Step.values()) {
                zos.putNextEntry(new ZipEntry(LearnOptions.featureFileNames.get((Object)s)));
                FeatureFile.writeToOutput(featureSets.get((Object)s), new PrintWriter(zos));
                zos.closeEntry();
            }
            zos.putNextEntry(new ZipEntry("objects"));
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(fg);
            oos.writeObject(pipeline.predicateReference);
            oos.writeObject(pipeline.argLabels);
            oos.flush();
            zos.closeEntry();
        }
        pipeline.train(sentences, zos);
        return pipeline;
    }

    public static Pipeline trainNewPipeline(Iterable<Sentence> sentences, Map<Step, File> featureFiles, ZipOutputStream zos, BrownCluster bc) throws IOException {
        FeatureGenerator fg = new FeatureGenerator();
        Map<Step, FeatureSet> featureSets = fg.readFeatureFiles(featureFiles, bc);
        fg.buildFeatureMaps(sentences);
        Pipeline pipeline = Pipeline.trainNewPipeline(sentences, fg, zos, featureSets);
        pipeline.fg = fg;
        return pipeline;
    }

    public static Pipeline fromZipFile(ZipFile zipFile, Step[] steps) throws IOException, ClassNotFoundException {
        long startTime = System.currentTimeMillis();
        System.out.println("Loading pipeline from " + zipFile.getName());
        ObjectInputStream ois = new ObjectInputStream(zipFile.getInputStream(zipFile.getEntry("objects")));
        FeatureGenerator fg = (FeatureGenerator)ois.readObject();
        PredicateReference predicateReference = (PredicateReference)ois.readObject();
        List argLabels = (List)ois.readObject();
        ois.close();
        HashMap<Step, FeatureSet> featureSets = new HashMap<Step, FeatureSet>();
        for (Step s : steps) {
            BufferedReader in = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipFile.getEntry(LearnOptions.featureFileNames.get((Object)s)))));
            Map<String, List<String>> names = FeatureFile.readFile(in);
            HashMap<String, List<Feature>> features = new HashMap<String, List<Feature>>();
            for (String POSPrefix : names.keySet()) {
                ArrayList<Feature> list = new ArrayList<Feature>();
                for (String name : names.get(POSPrefix)) {
                    list.add(fg.getCachedFeature(name));
                }
                features.put(POSPrefix, list);
            }
            featureSets.put(s, new FeatureSet((Map<String, List<Feature>>)features));
        }
        Pipeline pipeline = new Pipeline(fg, predicateReference, argLabels, featureSets);
        for (PipelineStep step : pipeline.steps) {
            step.readModels(zipFile);
        }
        pipeline.loadingTime = System.currentTimeMillis() - startTime;
        return pipeline;
    }

    public static Pipeline fromZipFile(ZipFile zipFile) throws ZipException, IOException, ClassNotFoundException {
        return Pipeline.fromZipFile(zipFile, new Step[]{Step.pi, Step.pd, Step.ai, Step.ac});
    }

    List<String> getArgLabels() {
        return this.argLabels;
    }

    FeatureGenerator getFg() {
        return this.fg;
    }

    Map<Step, FeatureSet> getFeatureSets() {
        return this.featureSets;
    }

    @Override
    protected String getSubStatus() {
        return "";
    }
}

