/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.options;

import java.io.File;
import java.io.PrintStream;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.ParseOptions;

public abstract class FullPipelineOptions {
    public Language.L l;
    public File tokenizer;
    public File lemmatizer;
    public File tagger;
    public File morph;
    public File parser;
    public File srl;
    public boolean reranker = false;
    public int aiBeam = 4;
    public int acBeam = 4;
    public double alfa = 1.0;
    public static int cores = Runtime.getRuntime().availableProcessors();
    public boolean skipPI = false;
    public boolean loadPreprocessorWithTokenizer = true;
    public static String NULL_LANGUAGE_NAME = "Unk";
    private static final String USAGE_OPTIONS = "-token  <file>    path to the tokenizer model file\n-lemma  <file>    path to the lemmatizer model file\n-tagger <file>    path to the pos tagger model file\n-morph  <file>    path to the morphological tagger model file\n-parser <file>    path to the parser model file\n-srl    <file>    path to the srl model file\n-reranker         use the reranker for the srl-system (default is not)\n-aibeam <int>     set the beam width of the ai component (default 4)\n-acbeam <int>     set the beam width of the ac component (default 4)\n-alfa   <double>  set the alfa for the reranker (default 1.0)";

    public ParseOptions getParseOptions() {
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.modelFile = this.srl;
        parseOptions.useReranker = this.reranker;
        parseOptions.global_aiBeam = this.aiBeam;
        parseOptions.global_acBeam = this.acBeam;
        parseOptions.global_alfa = this.alfa;
        parseOptions.skipPI = this.skipPI;
        return parseOptions;
    }

    public void parseCmdLineArgs(String[] args) {
        int ai = 0;
        if (args.length < 1) {
            System.err.println("Not enough arguments. Aborting.");
            this.printUsage(System.err);
            System.exit(1);
        }
        try {
            this.l = Language.L.valueOf(args[ai]);
        }
        catch (Exception e) {
            System.err.println("Unknown language: " + args[ai] + ", aborting.");
            System.err.println();
            this.printUsage(System.err);
            System.exit(1);
        }
        Language.setLanguage(this.l);
        ++ai;
        while (ai < args.length) {
            int newAi = this.tryParseArg(args, ai);
            if (ai == newAi) {
                newAi = this.trySubParseArg(args, ai);
            }
            if (ai == newAi) {
                System.err.println("Unknown option: " + args[ai]);
                System.exit(1);
            }
            ai = newAi;
        }
    }

    abstract int trySubParseArg(String[] var1, int var2);

    public int tryParseArg(String[] args, int ai) {
        if (args[ai].equals("-h") || args[ai].equals("-help") || args[ai].equals("--help")) {
            this.printUsage(System.err);
            System.exit(1);
        } else if (args[ai].equals("-token")) {
            this.tokenizer = new File(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-lemma")) {
            this.lemmatizer = new File(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-tagger")) {
            this.tagger = new File(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-morph")) {
            this.morph = new File(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-parser")) {
            this.parser = new File(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-srl")) {
            this.srl = new File(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-reranker")) {
            ++ai;
            this.reranker = true;
        } else if (args[ai].equals("-aiBeam")) {
            this.aiBeam = Integer.valueOf(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-acBeam")) {
            this.acBeam = Integer.valueOf(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-alfa")) {
            this.alfa = Double.parseDouble(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-cores")) {
            int n = ++ai;
            ++ai;
            cores = Integer.parseInt(args[n]);
        }
        return ai;
    }

    abstract Class<?> getIntendedEntryClass();

    abstract String getSubUsageOptions();

    public void printUsage(PrintStream out) {
        out.println("Usage:");
        out.println("java -cp ... " + this.getIntendedEntryClass().getName() + " <lang> <options>");
        out.println();
        out.println("Where <lang> is one of: " + Language.getLsString());
        out.println();
        out.println("And <options> correnspond to one of the following:");
        out.println(USAGE_OPTIONS);
        out.println(this.getSubUsageOptions());
        out.println();
        out.println("The model files neccessary vary between languages. E.g. German uses a morphological tagger,\nwhereas Chinese and English doesn't. The parser and srl models are always required though.\nFor Chinese, the tokenizer model should point to the data directory of the Stanford Chinese\nSegmenter, as provided in the 2008-05-21 distribution.\n\nFor further information check the website:\nhttp://code.google.com/p/mate-tools/\n");
    }
}

