/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.ml.liblinear;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.ml.LearningProblem;
import se.lth.cs.srl.ml.Model;
import se.lth.cs.srl.ml.liblinear.LibLinearModel;

public class LibLinearLearningProblem
implements LearningProblem {
    private File trainDataFile;
    private PrintWriter out;
    private ProblemWriter problemWriter;
    static int size = -1;

    public LibLinearLearningProblem(File trainDataFile, boolean histogram) {
        this.trainDataFile = trainDataFile;
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(trainDataFile)));
            this.problemWriter = histogram ? new HistogramProblemWriter(this.out) : new BinaryProblemWriter(this.out);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void addInstance(int label, Collection<Integer> indices) {
        this.out.print(label);
        this.out.print(' ');
        this.problemWriter.writeIndices(indices);
        this.out.println();
    }

    @Override
    public void addInstance(int label, Collection<Integer> indices, Hashtable<Integer, String> extentions, int start, int end, int offset) {
        this.out.print(label);
        this.out.print(' ');
        this.problemWriter.writeIndices(indices);
        this.problemWriter.writeExtentions(extentions, start, end, offset);
        this.out.println();
    }

    @Override
    public void done() {
        this.out.close();
    }

    public LibLinearModel train(boolean sparseModel) {
        File outputFile = new File(this.trainDataFile.toString() + ".model");
        if (Learn.learnOptions.deleteTrainFiles) {
            this.trainDataFile.deleteOnExit();
            outputFile.deleteOnExit();
        }
        try {
            LibLinearModel.trainModel(this.trainDataFile, outputFile);
            LibLinearModel ret = new LibLinearModel(outputFile, sparseModel);
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return null;
    }

    @Override
    public Model train() {
        return this.train(false);
    }

    private static class BinaryProblemWriter
    extends ProblemWriter {
        protected BinaryProblemWriter(PrintWriter out) {
            super(out);
        }

        @Override
        public void writeIndices(Collection<Integer> indices) {
            for (Integer index : indices) {
                this.out.print(index);
                this.out.print(":1 ");
            }
        }

        @Override
        void writeExtentions(Hashtable<Integer, String> exts, int start, int end, int offset) {
            for (int i = start; i <= end; ++i) {
                if (!exts.containsKey(i)) continue;
                this.out.print(' ');
                this.out.print(offset + i);
                this.out.print(':');
                this.out.print(exts.get(i));
            }
        }
    }

    private static class HistogramProblemWriter
    extends ProblemWriter {
        protected HistogramProblemWriter(PrintWriter out) {
            super(out);
        }

        @Override
        void writeIndices(Collection<Integer> indices) {
            Iterator<Integer> it = indices.iterator();
            if (it.hasNext()) {
                Integer last = null;
                Integer currentIndex = it.next();
                Integer next = null;
                int count = 0;
                do {
                    count = 1;
                    next = null;
                    while (it.hasNext() && (next = it.next()).equals(currentIndex)) {
                        ++count;
                    }
                    this.out.print(currentIndex);
                    this.out.print(':');
                    this.out.print(count);
                    this.out.print(' ');
                    last = currentIndex;
                    currentIndex = next;
                } while (it.hasNext());
                if (!last.equals(currentIndex) && currentIndex != null) {
                    this.out.print(currentIndex);
                    this.out.print(':');
                    this.out.print(count);
                    size = currentIndex;
                }
            }
        }

        @Override
        void writeExtentions(Hashtable<Integer, String> exts, int start, int end, int offset) {
            for (int i = start; i <= end; ++i) {
                if (!exts.containsKey(i)) continue;
                this.out.print(' ');
                this.out.print(offset + i);
                this.out.print(':');
                this.out.print(exts.get(i));
            }
        }
    }

    private static abstract class ProblemWriter {
        protected PrintWriter out;

        protected ProblemWriter(PrintWriter out) {
            this.out = out;
        }

        abstract void writeIndices(Collection<Integer> var1);

        abstract void writeExtentions(Hashtable<Integer, String> var1, int var2, int var3, int var4);
    }
}

