/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.languages;

import java.io.File;
import java.util.Map;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.FullPipelineOptions;
import se.lth.cs.srl.util.FileExistenceVerifier;

public class German
extends Language {
    @Override
    public String getDefaultSense(Predicate pred) {
        return pred.getLemma() + ".1";
    }

    @Override
    public String getCoreArgumentLabelSequence(Predicate pred, Map<Word, String> proposition) {
        Sentence sen = pred.getMySentence();
        StringBuilder ret = new StringBuilder();
        int size = sen.size();
        for (int i = 1; i < size; ++i) {
            Word word = (Word)sen.get(i);
            if (pred == word) {
                ret.append(" " + pred.getSense() + "/");
                ret.append(this.isPassiveVoice(pred) ? "P" : "A");
            }
            if (!proposition.containsKey(word)) continue;
            ret.append(" " + proposition.get(word));
        }
        return ret.toString();
    }

    private boolean isPassiveVoice(Predicate pred) {
        Word head = pred.getHead();
        return !head.isBOS() && pred.getPOS().equals("VVPP") && head.getLemma().equals("werden");
    }

    @Override
    public Language.L getL() {
        return Language.L.ger;
    }

    @Override
    public String getLexiconURL(Predicate pred) {
        return null;
    }

    @Override
    public String verifyLanguageSpecificModelFiles(FullPipelineOptions options) {
        File[] files = new File[]{options.lemmatizer, options.morph};
        return FileExistenceVerifier.verifyFiles(files);
    }

    @Override
    public String toLangNameString() {
        return "German";
    }
}

