/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.languages;

import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.FullPipelineOptions;
import se.lth.cs.srl.preprocessor.tokenization.StanfordPTBTokenizer;
import se.lth.cs.srl.preprocessor.tokenization.Tokenizer;
import se.lth.cs.srl.util.FileExistenceVerifier;

public class English
extends Language {
    private static Pattern CALSPattern = Pattern.compile("^A0|A1|A2|A3|A4$");

    @Override
    public String getDefaultSense(Predicate pred) {
        return pred.getLemma() + ".01";
    }

    @Override
    public String getCoreArgumentLabelSequence(Predicate pred, Map<Word, String> proposition) {
        Sentence sen = pred.getMySentence();
        StringBuilder ret = new StringBuilder();
        int size = sen.size();
        for (int i = 1; i < size; ++i) {
            String label;
            Word word = (Word)sen.get(i);
            if (pred == word) {
                ret.append(" " + pred.getSense() + "/");
                ret.append(this.isPassiveVoice(pred) ? "P" : "A");
            }
            if (!proposition.containsKey(word) || !CALSPattern.matcher(label = proposition.get(word)).matches()) continue;
            ret.append(" " + label);
        }
        return ret.toString();
    }

    private boolean isPassiveVoice(Predicate pred) {
        if (!pred.getPOS().equals("VBN")) {
            return false;
        }
        Word head = pred.getHead();
        return !head.isBOS() && head.getForm().matches("(be|am|are|is|was|were|been)");
    }

    @Override
    public Language.L getL() {
        return Language.L.eng;
    }

    @Override
    public String getLexiconURL(Predicate pred) {
        if (pred.getPOS().startsWith("V")) {
            return "http://verbs.colorado.edu/propbank/framesets-english/" + pred.getLemma() + "-v.html";
        }
        return "http://nlp.cs.nyu.edu/meyers/nombank/nombank.1.0/frames/" + pred.getLemma() + ".xml";
    }

    @Override
    public String verifyLanguageSpecificModelFiles(FullPipelineOptions options) {
        File[] files = new File[]{options.lemmatizer};
        return FileExistenceVerifier.verifyFiles(files);
    }

    @Override
    Tokenizer getDefaultTokenizer() {
        return new StanfordPTBTokenizer();
    }

    @Override
    public String toLangNameString() {
        return "English";
    }
}

