/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.FeatureName;
import se.lth.cs.srl.features.PredDependentAttrFeature;
import se.lth.cs.srl.features.TargetWord;
import se.lth.cs.srl.util.BrownCluster;

public class PredDependentBrown
extends PredDependentAttrFeature {
    private static final long serialVersionUID = 1L;
    private BrownCluster bc;
    private BrownCluster.ClusterVal cv;

    protected PredDependentBrown(FeatureName name, TargetWord tw, boolean includeAllWords, String POSPrefix, BrownCluster bc, BrownCluster.ClusterVal cv) {
        super(name, null, tw, includeAllWords, POSPrefix);
        this.bc = bc;
        this.cv = cv;
    }

    @Override
    public String getFeatureString(Sentence s, int predIndex, int argIndex) {
        Word w = this.wordExtractor.getWord(s, predIndex, argIndex);
        if (w.isBOS()) {
            return "ROOT";
        }
        return this.bc.getValue(w.getForm(), this.cv);
    }

    @Override
    public String getFeatureString(Predicate pred, Word arg) {
        Word w = this.wordExtractor.getWord(pred, arg);
        if (w.isBOS()) {
            return "ROOT";
        }
        return this.bc.getValue(w.getForm(), this.cv);
    }
}

