/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.FeatureName;

public abstract class Feature
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, Integer> indices = new HashMap<String, Integer>();
    protected int indexcounter = 1;
    protected int predMaxIndex;
    protected FeatureName name;
    protected final boolean includeArgs;
    private final boolean usedForPredicateIdentification;
    protected String POSPrefix;

    protected abstract void performFeatureExtraction(Sentence var1, boolean var2);

    public abstract void addFeatures(Sentence var1, Collection<Integer> var2, int var3, int var4, Integer var5, boolean var6);

    public abstract void addFeatures(Collection<Integer> var1, Predicate var2, Word var3, Integer var4, boolean var5);

    protected Feature(FeatureName name, boolean includeArgs, boolean usedForPredicateIdentification, String POSPrefix) {
        this.name = name;
        this.includeArgs = includeArgs;
        this.usedForPredicateIdentification = usedForPredicateIdentification;
        this.POSPrefix = POSPrefix;
    }

    protected void addMap(String val) {
        if (!(val == null || val.equals("") || val.equals("_") || this.indices.containsKey(val))) {
            this.indices.put(val, this.indexcounter);
            ++this.indexcounter;
        }
    }

    public int size(boolean includeAllWords) {
        if (includeAllWords) {
            return this.indices.size();
        }
        return this.predMaxIndex;
    }

    public Integer indexOf(String s) {
        Integer i = this.indices.get(s);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.getName() + ", " + this.getClass().toString());
        if (this.indices != null) {
            ret.append(", size: " + this.size(true));
        }
        ret.append(", POSPrefix: " + this.POSPrefix);
        return ret.toString();
    }

    public String getName() {
        return this.name.toString();
    }

    public void addPOSPrefix(String prefix) {
        if (prefix == null) {
            return;
        }
        if (this.POSPrefix == null) {
            this.POSPrefix = prefix;
            return;
        }
        if (prefix.startsWith(this.POSPrefix)) {
            return;
        }
        if (this.POSPrefix.startsWith(prefix)) {
            this.POSPrefix = prefix;
        } else {
            int len;
            int max = Math.min(prefix.length(), this.POSPrefix.length());
            for (len = 0; len < max && prefix.charAt(len) == this.POSPrefix.charAt(len); ++len) {
            }
            this.POSPrefix = prefix.substring(0, len);
        }
    }

    protected boolean doExtractFeatures(Word pred) {
        return pred.getPOS().startsWith(this.POSPrefix) || this.usedForPredicateIdentification && !Learn.learnOptions.skipNonMatchingPredicates && pred instanceof Predicate;
    }

    public void extractFeatures(Sentence s, boolean allWords) {
        if (allWords) {
            if (!this.usedForPredicateIdentification) {
                return;
            }
            this.performFeatureExtraction(s, allWords);
        } else {
            this.performFeatureExtraction(s, allWords);
        }
    }

    public void setDoneWithPredFeatureExtraction() {
        if (this.predMaxIndex != 0) {
            throw new Error("Multiple calls to setDoneWithPredFeatureExtraction() in Feature.java. You are wrong here. Check your implementation.");
        }
        this.predMaxIndex = this.indices.size();
    }

    public Map<String, Integer> getMap() {
        return this.indices;
    }
}

