/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.util.Collection;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.AttrFeature;
import se.lth.cs.srl.features.FeatureName;
import se.lth.cs.srl.features.TargetWord;

public class ArgDependentAttrFeature
extends AttrFeature {
    private static final long serialVersionUID = 1L;

    protected ArgDependentAttrFeature(FeatureName name, Word.WordData attr, TargetWord tw, String POSPrefix) {
        super(name, attr, tw, true, false, POSPrefix);
    }

    @Override
    protected void performFeatureExtraction(Sentence s, boolean allWords) {
        for (Predicate p : s.getPredicates()) {
            if (!this.doExtractFeatures(p)) continue;
            for (Word arg : p.getArgMap().keySet()) {
                Word w = this.wordExtractor.getWord(null, arg);
                if (w == null) continue;
                this.addMap(w.getAttr(this.attr));
            }
        }
    }

    @Override
    public String getFeatureString(Sentence s, int predIndex, int argIndex) {
        Word w = this.wordExtractor.getWord(s, predIndex, argIndex);
        if (w == null) {
            return null;
        }
        return w.getAttr(this.attr);
    }

    @Override
    public String getFeatureString(Predicate pred, Word arg) {
        Word w = this.wordExtractor.getWord(pred, arg);
        if (w == null) {
            return null;
        }
        return w.getAttr(this.attr);
    }

    @Override
    public void addFeatures(Sentence s, Collection<Integer> indices, int predIndex, int argIndex, Integer offset, boolean allWords) {
        this.addFeatures(indices, this.getFeatureString(s, predIndex, argIndex), offset, allWords);
    }

    @Override
    public void addFeatures(Collection<Integer> indices, Predicate pred, Word arg, Integer offset, boolean allWords) {
        this.addFeatures(indices, this.getFeatureString(pred, arg), offset, allWords);
    }

    private void addFeatures(Collection<Integer> indices, String featureString, Integer offset, boolean allWords) {
        if (featureString == null) {
            return;
        }
        Integer i = this.indexOf(featureString);
        if (i != -1 && (allWords || i < this.predMaxIndex)) {
            indices.add(i + offset);
        }
    }
}

