/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.corpus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Yield;

public class Word
implements Serializable {
    private static final long serialVersionUID = 12L;
    final Sentence mySentence;
    String[] args;
    String Form;
    String Lemma = "_";
    String POS = "_";
    String Deprel = "_";
    String Feats = "_";
    int headID;
    Word head;
    Set<Word> children;
    boolean isBOS;
    Word potentialArgument;
    final int idx;
    boolean isIgnoredPredicate = false;
    boolean isIgnoredArgument = false;
    Hashtable<Integer, String> sparse_extensions;
    public static final Comparator<Word> WORD_LINEAR_ORDER_COMPARATOR = new Comparator<Word>(){

        @Override
        public int compare(Word arg0, Word arg1) {
            return arg0.idx - arg1.idx;
        }
    };

    public Word(Sentence s) {
        this.idx = 0;
        this.isBOS = true;
        this.children = new HashSet<Word>();
        this.Form = "<ROOT-FORM>";
        this.Lemma = "<ROOT-LEMMA>";
        this.POS = "<ROOT-POS>";
        this.Feats = "<ROOT-FEATS>";
        this.Deprel = "<ROOT-DEPREL>";
        this.headID = -1;
        this.Form = "";
        this.Lemma = "";
        this.POS = "";
        this.Feats = "";
        this.Deprel = "";
        this.mySentence = s;
        this.sparse_extensions = new Hashtable();
    }

    public Word(String form, String lemma, String POS, String feats, Sentence mySentence, int idx) {
        this.idx = idx;
        this.Form = form;
        this.Lemma = lemma == null ? "_" : lemma;
        this.POS = POS == null ? "_" : POS;
        this.Feats = feats == null ? "_" : feats;
        this.mySentence = mySentence;
        this.children = Learn.learnOptions != null && Learn.learnOptions.deterministicPipeline ? new TreeSet<Word>(mySentence.wordComparator) : new HashSet<Word>();
    }

    public Word(Word w) {
        this.idx = w.idx;
        this.Form = w.Form;
        this.Lemma = w.Lemma;
        this.POS = w.POS;
        this.Feats = w.Feats;
        this.Deprel = w.Deprel;
        this.head = w.head;
        this.headID = w.headID;
        this.children = w.children;
        this.mySentence = w.mySentence;
        this.isBOS = w.isBOS;
        for (Word child : this.children) {
            child.head = this;
        }
        this.head.children.remove(w);
        this.head.children.add(this);
    }

    public Word(String[] CoNLL2009Columns, Sentence s, int idx) {
        this(CoNLL2009Columns[1], CoNLL2009Columns[2], CoNLL2009Columns[4], CoNLL2009Columns[7], s, idx);
        this.headID = Integer.parseInt(CoNLL2009Columns[8]);
        this.Deprel = CoNLL2009Columns[10];
        if (CoNLL2009Columns.length >= 14) {
            this.args = new String[CoNLL2009Columns.length - 14];
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = CoNLL2009Columns[14 + i];
            }
        }
    }

    public String getAttr(WordData attr) {
        switch (attr) {
            case Form: {
                return this.Form;
            }
            case Lemma: {
                return this.Lemma;
            }
            case POS: {
                return this.POS;
            }
            case Deprel: {
                return this.Deprel;
            }
        }
        throw new Error("You are wrong here.");
    }

    public String getForm() {
        return this.Form;
    }

    public String getLemma() {
        return this.Lemma;
    }

    public String getPOS() {
        return this.POS;
    }

    public String getFeats() {
        return this.Feats;
    }

    public Word getHead() {
        return this.head;
    }

    public int getHeadId() {
        return this.headID;
    }

    public String getDeprel() {
        return this.Deprel;
    }

    public Word getPotentialArgument() {
        return this.potentialArgument;
    }

    public Set<Word> getChildren() {
        return this.children;
    }

    public Sentence getMySentence() {
        return this.mySentence;
    }

    public String getArg(int i) {
        try {
            return this.args[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Corpus contains errors, missing semantic arguments, Word: " + this);
            return "_";
        }
    }

    public void setHead(Word h) {
        this.head = h;
        this.headID = this.mySentence.indexOf(h);
        h.children.add(this);
    }

    public void setDeprel(String deprel) {
        this.Deprel = deprel;
    }

    public void setPotentialArgument(Word potentialArgument) {
        this.potentialArgument = potentialArgument;
    }

    protected void setChildren(HashSet<Word> children) {
        this.children = children;
    }

    void clearArgArray() {
        this.args = null;
    }

    public boolean isBOS() {
        return this.isBOS;
    }

    public boolean isPassiveVoiceEng() {
        if (!this.getPOS().equals("VBN")) {
            return false;
        }
        return !this.head.isBOS && this.head.Form.matches("(be|am|are|is|was|were|been)");
    }

    public Word getLeftSibling() {
        for (int i = this.mySentence.indexOf(this) - 1; i > 0; --i) {
            if (!this.head.children.contains(this.mySentence.get(i))) continue;
            return (Word)this.mySentence.get(i);
        }
        return null;
    }

    public Word getRightSibling() {
        for (int i = this.mySentence.indexOf(this) + 1; i < this.mySentence.size(); ++i) {
            if (!this.head.children.contains(this.mySentence.get(i))) continue;
            return (Word)this.mySentence.get(i);
        }
        return null;
    }

    public Word getRightmostDep() {
        if (this.children.isEmpty()) {
            return null;
        }
        Word ret = null;
        for (int i = this.mySentence.indexOf(this); i < this.mySentence.size(); ++i) {
            if (!this.children.contains(this.mySentence.get(i))) continue;
            ret = (Word)this.mySentence.get(i);
        }
        return ret;
    }

    public Word getLeftmostDep() {
        if (this.children.isEmpty()) {
            return null;
        }
        Word ret = null;
        for (int i = this.mySentence.indexOf(this); i > 0; --i) {
            if (!this.children.contains(this.mySentence.get(i))) continue;
            ret = (Word)this.mySentence.get(i);
        }
        return ret;
    }

    public void setIgnoredPredicate() {
        this.isIgnoredPredicate = true;
    }

    public boolean getIgnoredPredicate() {
        return this.isIgnoredPredicate;
    }

    public void setIgnoredArgument() {
        this.isIgnoredArgument = true;
    }

    public boolean getIgnoredArgument() {
        return this.isIgnoredArgument;
    }

    public static List<Word> findPath(Word pred, Word arg) {
        int j;
        List<Word> predPath = Word.pathToRoot(pred);
        List<Word> argPath = Word.pathToRoot(arg);
        ArrayList<Word> ret = new ArrayList<Word>();
        int commonIndex = 0;
        int min = predPath.size() < argPath.size() ? predPath.size() : argPath.size();
        for (int i = 0; i < min; ++i) {
            if (predPath.get(i) != argPath.get(i)) continue;
            commonIndex = i;
        }
        for (j = predPath.size() - 1; j >= commonIndex; --j) {
            ret.add(predPath.get(j));
        }
        for (j = commonIndex + 1; j < argPath.size(); ++j) {
            ret.add(argPath.get(j));
        }
        return ret;
    }

    public static List<Word> pathToRoot(Word w) {
        if (w.isBOS) {
            ArrayList<Word> path = new ArrayList<Word>();
            path.add(w);
            return path;
        }
        List<Word> path = Word.pathToRoot(w.head);
        path.add(w);
        return path;
    }

    public String toString() {
        return this.Form + "\t" + this.Lemma + "\t" + this.Lemma + "\t" + this.POS + "\t" + this.POS + "\t_\t" + this.Feats + "\t" + this.headID + "\t" + this.headID + "\t" + this.Deprel + "\t" + this.Deprel;
    }

    private static Collection<Word> getDominated(Collection<Word> words) {
        HashSet<Word> ret = new HashSet<Word>(words);
        for (Word c : words) {
            ret.addAll(Word.getDominated(c.getChildren()));
        }
        return ret;
    }

    public Yield getYield(Predicate pred, String argLabel, Set<Word> argSet) {
        Yield ret = new Yield(pred, this.mySentence, argLabel);
        ret.add(this);
        if (pred == this) {
            return ret;
        }
        for (Word child : this.children) {
            Collection<Word> subtree;
            if (argSet.contains(child) || (subtree = Word.getDominated(Arrays.asList(child))).contains(pred)) continue;
            ret.addAll(subtree);
        }
        return ret;
    }

    public int getIdx() {
        return this.idx;
    }

    public void setSparseEntensions(Hashtable<Integer, String> exs) {
        if (exs == null) {
            return;
        }
        this.sparse_extensions = exs;
    }

    public Hashtable<Integer, String> getSparseEntensions() {
        return this.sparse_extensions;
    }

    public static enum WordData {
        Form,
        Lemma,
        POS,
        Deprel,
        Pred;

    }
}

