/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.srl.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import se.lth.cs.srl.SemanticRoleLabeler;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.corpus.Yield;
import se.lth.cs.srl.io.DepsOnlyCoNLL09Reader;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.CompletePipelineCMDLineOptions;
import se.lth.cs.srl.options.ParseOptions;
import se.lth.cs.srl.pipeline.Pipeline;
import se.lth.cs.srl.pipeline.Reranker;
import se.lth.cs.srl.pipeline.Step;
import se.lth.cs.srl.preprocessor.Preprocessor;

public class MuseMappingInterface {
    private static Preprocessor pp;
    private SemanticRoleLabeler srl;
    private static CompletePipelineCMDLineOptions options;
    public static ParseOptions parseOptions;
    private static MuseMappingInterface instance;

    public static synchronized MuseMappingInterface getInstance(String lemmatizerModel, String posModel, String parserModel, String srlModel, boolean useReranker) throws Exception {
        if (instance == null) {
            instance = new MuseMappingInterface(lemmatizerModel, posModel, parserModel, srlModel, useReranker);
        }
        return instance;
    }

    private MuseMappingInterface(String lemmatizerModel, String posModel, String parserModel, String srlModel, boolean useReranker) throws Exception {
        Language.setLanguage(Language.L.eng);
        parseOptions = new ParseOptions(srlModel, useReranker);
        options = new CompletePipelineCMDLineOptions();
        options = new CompletePipelineCMDLineOptions();
        if (lemmatizerModel != null) {
            MuseMappingInterface.options.lemmatizer = new File(lemmatizerModel);
        }
        if (posModel != null) {
            MuseMappingInterface.options.tagger = new File(posModel);
        }
        if (parserModel != null) {
            MuseMappingInterface.options.parser = new File(parserModel);
        }
        pp = Language.getLanguage().getPreprocessor(options);
        if (MuseMappingInterface.parseOptions.useReranker) {
            this.srl = new Reranker(parseOptions);
        } else {
            ZipFile zipFile = new ZipFile(MuseMappingInterface.parseOptions.modelFile);
            this.srl = MuseMappingInterface.parseOptions.skipPI ? Pipeline.fromZipFile(zipFile, new Step[]{Step.pd, Step.ai, Step.ac}) : Pipeline.fromZipFile(zipFile);
            zipFile.close();
        }
    }

    public String parse(List<String> text) {
        String[] textt = text.toArray(new String[text.size()]);
        String[] textt2 = new String[text.size() + 1];
        textt2[0] = "";
        for (int i = 0; i < textt.length; ++i) {
            String[] tmps = textt[i].split("\\s+");
            textt2[i + 1] = tmps.length > 1 ? tmps[1] : tmps[0];
        }
        Sentence s = new Sentence(pp.preprocess(textt2), false);
        System.out.println("Start parsing... ");
        this.srl.parseSentence(s);
        System.out.println("Finish!");
        return this.getResults(s);
    }

    public List<String> parse(String pathToFile) {
        DepsOnlyCoNLL09Reader reader = new DepsOnlyCoNLL09Reader(new File(pathToFile));
        List<Sentence> sens = reader.readAll();
        ArrayList<String> lst = new ArrayList<String>();
        System.out.println("Start parsing... ");
        for (Sentence s : sens) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (Word w : s) {
                if (w.isBOS()) continue;
                tokens.add(w.getForm());
            }
            lst.add(this.parse(tokens));
        }
        System.out.println("Finish!");
        return lst;
    }

    private String getResults(Sentence s) {
        HashMap m = new HashMap();
        StringBuilder sb = new StringBuilder();
        sb.append("\n---SENTENCE---\n");
        sb.append("\n");
        String type = "NV";
        for (Predicate pred : s.getPredicates()) {
            if (type.equals("V") && !pred.getPOS().startsWith("V") || type.equals("N") && !pred.getPOS().startsWith("N") || type.equals("NV") && !pred.getPOS().startsWith("N") && !pred.getPOS().startsWith("V")) continue;
            sb.append("---FRAME---\n");
            sb.append("pred: " + pred.getForm() + "\n");
            ArrayList<String> roles = new ArrayList<String>();
            for (Word w : pred.getArgMap().keySet()) {
                if (roles.contains(pred.getArgumentTag(w))) continue;
                roles.add(pred.getArgumentTag(w));
            }
            Collections.sort(roles);
            TreeSet<Yield> yields = new TreeSet<Yield>();
            Map<Word, String> argmap = pred.getArgMap();
            for (Word arg : argmap.keySet()) {
                yields.addAll(arg.getYield(pred, argmap.get(arg), argmap.keySet()).explode());
            }
            for (String role : roles) {
                sb.append(role + ": ");
                for (Yield y : yields) {
                    if (!y.getArgLabel().equals(role)) continue;
                    if (!y.isContinuous()) {
                        System.out.println("Something wrong, we have discontinous yields!");
                        continue;
                    }
                    sb.append(MuseMappingInterface.YieldToString(y, s) + " ");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private static String YieldToString(Yield y, Sentence s) {
        String tmp = "";
        int first = s.indexOf(y.first());
        int end = s.indexOf(y.last());
        for (int i = first; i <= end; ++i) {
            tmp = tmp + ((Word)s.get(i)).getForm();
            if (i >= end) continue;
            tmp = tmp + " ";
        }
        return tmp;
    }

    public static void main(String[] args) throws Exception {
        MuseMappingInterface mi = MuseMappingInterface.getInstance("/Users/quynhdo/Documents/MUSE/SRL/models/lemmatizer.model", "/Users/quynhdo/Documents/MUSE/SRL/models/postagger.model", "/Users/quynhdo/Documents/MUSE/SRL/models/parser.model", "/Users/quynhdo/Documents/MUSE/SRL/models/srl.model", false);
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("1\tThe\tthe\tthe\tDT\tDT\t_\t_\t2\t2\tNMOD\tNMOD\t_\t_");
        lst.add("2\teconomy\teconomy\teconomy\tNN\tNN\t_\t_\t4\t4\tNMOD\tNMOD\t_\t_");
        lst.add("3\t's\t's\t's\tPOS\tPOS\t_\t_\t2\t2\tSUFFIX\tSUFFIX\t_\t_");
        lst.add("4\ttemperature\ttemperature\ttemperature\tNN\tNN\t_\t_\t5\t5\tSBJ\tSBJ\t_\t_");
        lst.add("5\twill\twill\twill\tMD\tMD\t_\t_\t0\t0\tROOT\tROOT\t_\t_");
        lst.add("6\tbe\tbe\tbe\tVB\tVB\t_\t_\t5\t5\tVC\tVC\t_\t_");
        lst.add("7\ttaken\ttake\ttake\tVBN\tVBN\t_\t_\t6\t6\tVC\tVC\t_ _");
        lst.add("8\tfrom\tfrom\tfrom\tIN\tIN\t_\t_\t7\t7\tADV\tADV\t_\t_");
        lst.add("9\tseveral\tseveral\tseveral\tDT\tDT\t_\t_\t11\t11\tNMOD\tNMOD\t_\t_");
        lst.add("10\tvantage\tvantage\tvantage\tNN\tNN\t_\t_\t11\t11\tNMOD\tNMOD\t_\t_");
        lst.add("11\tpoints\tpoint\tpoint\tNNS\tNNS\t_\t_\t8\t8\tPMOD\tPMOD\t_\t_");
        List<String> tmp = mi.parse("/Users/quynhdo/Desktop/TEMP/conllformat2.txt");
        System.out.println(tmp.toString());
    }
}

