/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.srl.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.corpus.Yield;
import se.lth.cs.srl.io.AllCoNLL09Reader;

public class InputForMapping {
    public void run(String srl_input, String quotation_input, String output) throws IOException {
        ArrayList<Quotation> arr = this.readFile(quotation_input);
        List<Sentence> sentences = new AllCoNLL09Reader(new File(srl_input)).readAll();
        StringBuilder sb = new StringBuilder();
        int idx = 1;
        for (Sentence s : sentences) {
            sb.append("\n---SENTENCE---\n");
            String ss = "";
            for (Word w : s) {
                ss = ss + w.getForm();
                ss = ss + " ";
            }
            sb.append(ss);
            sb.append("\n");
            String type = "NV";
            for (Predicate pred : s.getPredicates()) {
                if (type.equals("V") && !pred.getPOS().startsWith("V") || type.equals("N") && !pred.getPOS().startsWith("N") || type.equals("NV") && !pred.getPOS().startsWith("N") && !pred.getPOS().startsWith("V")) continue;
                sb.append("---FRAME---\n");
                sb.append("pred: " + pred.getForm() + "\n");
                ArrayList<String> roles = new ArrayList<String>();
                for (Word w : pred.getArgMap().keySet()) {
                    if (roles.contains(pred.getArgumentTag(w))) continue;
                    roles.add(pred.getArgumentTag(w));
                }
                Collections.sort(roles);
                TreeSet<Yield> yields = new TreeSet<Yield>();
                Map<Word, String> argmap = pred.getArgMap();
                for (Word arg : argmap.keySet()) {
                    yields.addAll(arg.getYield(pred, argmap.get(arg), argmap.keySet()).explode());
                }
                for (String role : roles) {
                    sb.append(role + ": ");
                    for (Yield y : yields) {
                        if (!y.getArgLabel().equals(role)) continue;
                        if (!y.isContinuous()) {
                            System.out.println("Something wrong, we have discontinous yields!");
                            continue;
                        }
                        sb.append(InputForMapping.YieldToString(y, s) + " ");
                    }
                    sb.append("\n");
                }
            }
            for (Quotation q : arr) {
                if (q.sent_id != idx + 1) continue;
                sb.append("---QUOTATION---\n");
                sb.append("ComSubj: " + q.subject + "\n");
                sb.append("ComType: " + q.type + "\n");
                sb.append("ComTarget: " + q.target + "\n");
                sb.append("Quote: " + q.quote + "\n");
            }
            ++idx;
        }
        Path path = Paths.get(output, new String[0]);
        Files.write(path, sb.toString().getBytes(), new OpenOption[0]);
    }

    private static String YieldToString(Yield y, Sentence s) {
        String tmp = "";
        int first = s.indexOf(y.first());
        int end = s.indexOf(y.last());
        for (int i = first; i <= end; ++i) {
            tmp = tmp + ((Word)s.get(i)).getForm();
            if (i >= end) continue;
            tmp = tmp + " ";
        }
        return tmp;
    }

    public ArrayList<Quotation> readFile(String input) {
        Path path = Paths.get(input, new String[0]);
        ArrayList<Quotation> arr = new ArrayList<Quotation>();
        try {
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            for (String line : lines) {
                line.trim();
                if (line.matches("\\s*")) continue;
                String[] tmps = line.split("---");
                Quotation q = new Quotation();
                q.sent_id = Integer.parseInt(tmps[0]);
                q.quote = tmps[1];
                q.type = tmps[2];
                String[] ts = tmps[3].split(":");
                if (ts[0].equals("Speaker")) {
                    q.subject = ts[1];
                }
                if (ts[0].equals("Targer")) {
                    q.target = ts[1];
                }
                if ((ts = tmps[4].split(":"))[0].equals("Speaker")) {
                    q.subject = ts[1];
                }
                if (ts[0].equals("Targer")) {
                    q.target = ts[1];
                }
                arr.add(q);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return arr;
    }

    public static void main(String[] args) throws IOException {
        InputForMapping ii = new InputForMapping();
        ii.run(args[0], args[1], args[2]);
    }

    public class Quotation {
        public String quote;
        public String type;
        public String subject;
        public String target;
        public int sent_id;
    }
}

