/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.srl.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.corpus.Yield;
import se.lth.cs.srl.io.AllCoNLL09Reader;
import se.lth.cs.srl.io.CoNLL09Writer;

public class ConsituentOutput {
    public static void getConstituentOutput(Sentence s, Predicate pred) {
        ArrayList<String> roles = new ArrayList<String>();
        for (Word w : pred.getArgMap().keySet()) {
            if (roles.contains(pred.getArgumentTag(w))) continue;
            roles.add(pred.getArgumentTag(w));
        }
        Collections.sort(roles);
        TreeSet yields = new TreeSet();
        Map<Word, String> argmap = pred.getArgMap();
        HashMap<Word, String> argmap2 = new HashMap<Word, String>();
        for (Word arg : argmap.keySet()) {
            Collection<Yield> ys = arg.getYield(pred, argmap.get(arg), argmap.keySet()).explode();
            String lbl = argmap.get(arg);
            String newlbl = "";
            for (Yield y : ys) {
                String ss = y.getArgLabel() + "___" + ((Word)y.first()).getIdx() + "___" + ((Word)y.last()).getIdx();
                newlbl = newlbl + "|" + ss;
            }
            argmap2.put(arg, lbl + newlbl);
        }
        pred.setArgMap(argmap2);
    }

    public static void getConstituentOutput(String input, String output) {
        List<Sentence> sens = new AllCoNLL09Reader(new File(input)).readAll();
        for (Sentence s : sens) {
            for (Predicate pred : s.getPredicates()) {
                ConsituentOutput.getConstituentOutput(s, pred);
            }
        }
        CoNLL09Writer writer = new CoNLL09Writer(new File(output));
        for (Sentence s : sens) {
            writer.write(s);
        }
        writer.close();
    }

    public static void main(String[] args) {
        ConsituentOutput.getConstituentOutput("/Users/quynhdo/Documents/MUSE_SRLv2.0/samples/output/tuk.srl", "/Users/quynhdo/Documents/MUSE_SRLv2.0/samples/output/tuk.constituent.srl");
    }
}

