/**
 * Copyright 1998-2010 Epic Games, Inc. All Rights Reserved.
 *
 * This is the base class of all Mobile sequence events.  
 */
class SeqEvent_HudRenderText extends SeqEvent_HudRender;

/** The Font to draw */
var(HUD) font DisplayFont;

/** The Color to draw the text in */
var(HUD) color DisplayColor;

/** The Location to display the text at */
var(HUD) vector DisplayLocation;

/** The text to draw.  NOTE: You can set this via the variable link */
var(HUD) string DisplayText;

/** 
 * Perform the actual rendering
 */
function Render(Canvas TargetCanvas, Hud TargetHud)
{
	if (DisplayFont != none)
	{
		TargetCanvas.Font = DisplayFont;
	}

	TargetCanvas.DrawColor = DisplayColor;
	TargetCanvas.SetPos(DisplayLocation.X, DisplayLocation.Y);
	TargetCanvas.DrawText(DisplayText);
}


defaultproperties
{
	ObjName="Draw Text"
	ObjCategory="HUD"

	VariableLinks(2)=(ExpectedType=class'SeqVar_Vector',LinkDesc="Display Location",bWriteable=true,PropertyName=DisplayLocation)
}