﻿/**
 * The StatusIndicator component displays the status of an event or action using its timeline as the visual indicator. The value of the StatusIndicator will be interpolated with the minimum and maximum values to generate a frame number that will be played in the component’s timeline. Since the component’s timeline is used to display the status, it provides absolute freedom in creating innovative visual indicators.
 
	<b>Inspectable Properties</b>
	A MovieClip that derives from the StatusIndicator component will have the following inspectable properties:<ul>
	<li><i>visible</i>: Hides the component if set to false.</li>
	<li><i>disabled</i>: Disables the component if set to true.</li>
	<li><i>value</i>: The status value of an event or action. It is interpolated between the minimum and maximum values to generate a frame number to be played.</li>
	<li><i>minimum</i>: The minimum value used to interpolate the target frame.</li>
	<li><i>maximum</i>: The maximum value used to interpolate the target frame.</li>
	<li><i>enableInitCallback</i>: If set to true, _global.CLIK_loadCallback() will be fired when a component is loaded and _global.CLIK_unloadCallback will be called when the component is unloaded. These methods receive the instance name, target path, and a reference the component as parameters.  _global.CLIK_loadCallback and _global.CLIK_unloadCallback should be overriden from the game engine using GFx FunctionObjects.</li></ul>
	
	<b>States</b>
	There are no states for the StatusIndicator component. The component’s frames are used to display the status of an event or action. 
	
	<b>Events</b>
	All event callbacks receive a single Object parameter that contains relevant information about the event. The following properties are common to all events. <ul>
	<li><i>type</i>: The event type.</li>
	<li><i>target</i>: The target that generated the event.</li></ul>
		
	No special events are generated by the StatusIndicator. The properties listed next to the event are provided in addition to the common properties.<ul>
	<li><i>show</i>: The component’s visible property has been set to true at runtime.</li>
	<li><i>hide</i>: The component’s visible property has been set to false at runtime.</li>
 */

/**********************************************************************
 Copyright (c) 2009 Scaleform Corporation. All Rights Reserved.

 Portions of the integration code is from Epic Games as identified by Perforce annotations.
 Copyright © 2010 Epic Games, Inc. All rights reserved.
 
 Licensees may use this file in accordance with the valid Scaleform
 License Agreement provided with the software. This file is provided 
 AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE WARRANTY OF DESIGN, 
 MERCHANTABILITY AND FITNESS FOR ANY PURPOSE.
**********************************************************************/

/*
*/
import flash.external.ExternalInterface; 
import gfx.core.UIComponent;
import gfx.ui.InputDetails;
import gfx.ui.NavigationCode;

[InspectableList("disabled", "visible", "minimum", "maximum", "value", "enableInitCallback")]
class gfx.controls.StatusIndicator extends UIComponent {
	
// Constants:

// Public Properties:

// Private Properties:
	private var _maximum:Number = 10;
	private var _minimum:Number = 0;
	private var _value:Number = 0;
	
// UI Elements:
	

// Initialization:
	/**
	 * The constructor is called when a StatusIndicator or a sub-class of StatusIndicator is instantiated on stage or by using {@code attachMovie()} in ActionScript. This component can <b>not</b> be instantiated using {@code new} syntax. When creating new components that extend StatusIndicator, ensure that a {@code super()} call is made first in the constructor.
	 */
	public function StatusIndicator() { super(); }
	
// Public Methods:
	/**
	 * The maximum number the {@code value} can be set to.
	 */
	[Inspectable(defaultValue="10")]
	public function get maximum():Number { return _maximum;	}
	public function set maximum(value:Number):Void {
		if (_maximum == value) { return; }
		_maximum = value;
		updatePosition();
	}
	
	/**
	 * The minimum number the {@code value} can be set to.
	 */
	[Inspectable(defaultValue="0")]
	public function get minimum():Number { return _minimum; }
	public function set minimum(value:Number):Void { 
		if (_minimum == value) { return; }
		_minimum = value;
		updatePosition();
	}
	
	/**
	 * The current value between the {@code maximum} and {@code minimum}.
	 * @see #maximum
	 * @see #minimum
	 */
	[Inspectable(defaultValue="0")]
	public function get value():Number { return _value; }
	public function set value(value:Number):Void {
		//if (value == this.value) { return; }
		var range = Math.max(_minimum, Math.min(_maximum, value));
		if (_value == range) { return; } 
		_value = range;
		updatePosition();
	}
	
	/**
	 * The {@code value} of the {@code StatusIndicator}, to make it polymorphic with a {@link ScrollIndicator}.
	 */
	public function get position():Number { return _value; }
	public function set position(value:Number):Void { this.value = value; }
		
	/** @exclude */
	public function toString():String {
		return "[Scaleform StatusIndicator " + _name + "]";
	}
	
	
// Private Methods:
	private function configUI():Void {
		super.configUI();
		tabEnabled = false;		
	}
	
	private function draw():Void {
		if (sizeIsInvalid) { 
			_width = __width;
			_height = __height;
		}
		updatePosition();
	}
	
	// This is the default behaviour. which can be changed by overriding this method, or defining it in the timeline.
	private function updatePosition():Void {
		if (_disabled) { return; }
		var percent:Number = (_value - _minimum) / (_maximum - _minimum);
		gotoAndStop(Math.max(1, Math.round(percent * _totalframes)));
	}
	
}