/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VariableContextTest
extends Assert {
    private VariableContext parentCtx;
    private VariableContext ctx;

    @Before
    public void initialize() {
        this.parentCtx = new VariableContext();
        this.parentCtx.put("parent", (Object)"parentValue");
        this.parentCtx.put("override", (Object)"parentOverrideValue");
        this.ctx = new VariableContext(this.parentCtx, Arguments.EMPTY);
        this.ctx.put("child", (Object)"childValue");
        this.ctx.put("override", (Object)"childOverrideValue");
    }

    @Test
    public void childValue() {
        Object result = this.ctx.getValue("child");
        VariableContextTest.assertEquals((Object)"childValue", (Object)result);
    }

    @Test
    public void parentValue() {
        Object result = this.ctx.getValue("parent");
        VariableContextTest.assertEquals((Object)"parentValue", (Object)result);
    }

    @Test
    public void childOverridesParentValue() {
        Object result = this.ctx.getValue("override");
        VariableContextTest.assertEquals((Object)"childOverrideValue", (Object)result);
    }

    @Test
    public void parentKeepsOverridenValue() {
        Object result = this.parentCtx.getValue("override");
        VariableContextTest.assertEquals((Object)"parentOverrideValue", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingValue() {
        this.ctx.getValue("missing");
    }
}

