/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PlanTest;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.io.IOException;
import org.junit.Before;
import org.junit.Test;

public class LapChainToPathTest
extends PlanTest {
    private PoshPlan plan;
    private DriveCollection dc;

    @Before
    public void init() throws IOException, ParseException {
        this.plan = this.parsePlan("testplans/LapPath-00-variouspaths.lap");
        this.dc = this.plan.getDriveCollection();
    }

    private LapPath getDrivePath(int driveId) {
        return LapPath.DRIVE_COLLECTION_PATH.concat(LapType.DRIVE_ELEMENT, driveId);
    }

    private TriggeredAction getActionPatternAction(int actionPatternId, int actionId) {
        return this.plan.getActionPattern(actionPatternId).getAction(actionId);
    }

    private TriggeredAction getChoiceAction(int competenceId, int choiceId) {
        return this.plan.getCompetence(competenceId).getChoice(choiceId).getAction();
    }

    private TriggeredAction getDriveAction(int driveId) {
        return this.dc.getDrive(driveId).getAction();
    }

    @Test
    public void emptyChainGivesDC() {
        LapChain emptyChain = new LapChain();
        LapChainToPathTest.assertEquals((Object)LapPath.DRIVE_COLLECTION_PATH, (Object)emptyChain.toPath());
    }

    @Test
    public void senseChain() {
        LapPath sensePath = this.getDrivePath(3).concat(LapType.ACTION, 0).concat(LapType.COMPETENCE, 1).concat(LapType.COMPETENCE_ELEMENT, 1).concat(LapType.SENSE, 1);
        LapChain senseChain = new LapChain().derive(this.getDriveAction(3), (PoshElement)this.plan.getCompetence(1)).derive((PoshElement)this.plan.getCompetence(1).getChoice(1).getTrigger().get(1));
        LapChainToPathTest.assertEquals((Object)sensePath, (Object)senseChain.toPath());
    }

    @Test
    public void driveActionChain() {
        int driveId = 1;
        LapPath drivePath = this.getDrivePath(driveId).concat(LapType.ACTION, 0);
        TriggeredAction secondDriveAction = this.getDriveAction(driveId);
        LapChain driveActionChain = new LapChain().derive((PoshElement)secondDriveAction);
        LapChainToPathTest.assertEquals((Object)drivePath, (Object)driveActionChain.toPath());
    }

    @Test
    public void actionPatternChain() {
        int driveId = 2;
        int actionPatternId = 0;
        LapPath actionPatternPath = this.getDrivePath(driveId).concat(LapType.ACTION, 0).concat(LapType.ACTION_PATTERN, actionPatternId);
        TriggeredAction secondDriveAction = this.getDriveAction(driveId);
        ActionPattern referencedActionPattern = this.plan.getActionPattern(actionPatternId);
        LapChainToPathTest.assertEquals((Object)referencedActionPattern.getName(), (Object)secondDriveAction.getName());
        LapChain actionPatternChain = new LapChain().derive(secondDriveAction, (PoshElement)referencedActionPattern);
        LapChainToPathTest.assertEquals((Object)actionPatternPath, (Object)actionPatternChain.toPath());
    }

    @Test
    public void competenceChain() {
        int driveId = 3;
        int competenceId = 1;
        LapPath actionPatternPath = this.getDrivePath(driveId).concat(LapType.ACTION, 0).concat(LapType.COMPETENCE, competenceId);
        TriggeredAction thirdDriveAction = this.getDriveAction(driveId);
        Competence referencedCompetence = this.plan.getCompetence(competenceId);
        LapChainToPathTest.assertEquals((Object)referencedCompetence.getName(), (Object)thirdDriveAction.getName());
        LapChain competenceChain = new LapChain().derive(thirdDriveAction, (PoshElement)referencedCompetence);
        LapChainToPathTest.assertEquals((Object)actionPatternPath, (Object)competenceChain.toPath());
    }

    @Test
    public void adoptChain() {
        int driveId = 4;
        int adoptId = 0;
        LapPath adoptPath = this.getDrivePath(driveId).concat(LapType.ACTION, 0).concat(LapType.ADOPT, adoptId);
        TriggeredAction driveAction = this.getDriveAction(driveId);
        Adopt adopt = this.plan.getAdopt(adoptId);
        LapChainToPathTest.assertEquals((Object)adopt.getName(), (Object)driveAction.getName());
        LapChain adoptChain = new LapChain().derive(driveAction, (PoshElement)adopt);
        LapChainToPathTest.assertEquals((Object)adoptPath, (Object)adoptChain.toPath());
    }

    @Test
    public void longChain() {
        LapPath longPath = this.getDrivePath(0).concat(LapType.ACTION, 0).concat(LapType.COMPETENCE, 0).concat(LapType.COMPETENCE_ELEMENT, 0).concat(LapType.ACTION, 0).concat(LapType.COMPETENCE, 2).concat(LapType.COMPETENCE_ELEMENT, 0).concat(LapType.ACTION, 0).concat(LapType.ACTION_PATTERN, 1).concat(LapType.ACTION, 3);
        LapChainToPathTest.assertEquals((Object)"ac4", (Object)((TriggeredAction)longPath.traversePath(this.plan)).getName());
        LapChain longChain = new LapChain().derive(this.getDriveAction(0), (PoshElement)this.plan.getCompetence(0)).derive(this.getChoiceAction(0, 0), (PoshElement)this.plan.getCompetence(2)).derive(this.getChoiceAction(2, 0), (PoshElement)this.plan.getActionPattern(1)).derive((PoshElement)this.getActionPatternAction(1, 3));
        LapChainToPathTest.assertEquals((Object)longPath, (Object)longChain.toPath());
    }
}

