/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.IElementMethod;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.RemoveTest;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompetenceTest {
    List<CompetenceElement> elements;
    List<DummyListener> listeners;
    int num = 10;
    int reps = 100;

    @Test
    public void testAddElement() throws DuplicateNameException {
        System.out.println("addElement");
        Competence instance = new Competence("test", new FormalParameters(), Collections.emptyList());
        DummyListener listener = new DummyListener();
        instance.addElementListener((PoshElementListener)listener);
        CompetenceElement element = LapElementsFactory.createCompetenceElement((String)"choice-1");
        instance.addElement(element);
        Assert.assertTrue((listener.lastAddedChild == element ? 1 : 0) != 0);
    }

    @Test(expected=DuplicateNameException.class)
    public void testAddElementDuplicateName() throws DuplicateNameException {
        System.out.println("addElement - duplicate name");
        Competence instance = new Competence("test", new FormalParameters(), Collections.emptyList());
        String name = "choice";
        instance.addElement(LapElementsFactory.createCompetenceElement((String)name));
        instance.addElement(LapElementsFactory.createCompetenceElement((String)name));
    }

    @Test(expected=AssertionError.class)
    public void testAddElementLeakingParent() throws DuplicateNameException {
        System.out.println("addElement - leaking parent");
        Competence instance = new Competence("test", new FormalParameters(), Collections.emptyList());
        instance.addElement(LapElementsFactory.createCompetenceElement((String)"test-element"));
        Competence leak = new Competence("leak", new FormalParameters(), Collections.emptyList());
        CompetenceElement leakElement = LapElementsFactory.createCompetenceElement((String)"leak-element");
        leak.addElement(leakElement);
        instance.addElement(leakElement);
    }

    @Test
    public void testSetName() throws Exception {
        System.out.println("setName");
        String orgName = "test-set-name";
        String newName = "new-name";
        Competence instance = new Competence(orgName, new FormalParameters(), Collections.emptyList());
        DummyListener listener = new DummyListener();
        instance.addElementListener((PoshElementListener)listener);
        instance.setName(newName);
        PropertyChangeEvent evt = listener.lastPropertyChange;
        Assert.assertTrue((evt.getPropertyName().equals("cnName") && evt.getOldValue().equals(orgName) && evt.getNewValue().equals(newName) ? 1 : 0) != 0);
        Assert.assertEquals((Object)instance.getName(), (Object)newName);
    }

    @Test(expected=InvalidNameException.class)
    public void testSetNameInvalidName() throws Exception {
        System.out.println("setName - invalid name");
        String orgName = "test-set-name";
        String newName = "new name";
        Competence instance = new Competence(orgName, new FormalParameters(), Collections.emptyList());
        DummyListener listener = new DummyListener();
        instance.addElementListener((PoshElementListener)listener);
        try {
            instance.setName(newName);
        }
        catch (InvalidNameException ex) {
            Assert.assertNull((Object)listener.lastPropertyChange);
            Assert.assertEquals((Object)instance.getName(), (Object)orgName);
            throw ex;
        }
        Assert.fail((String)"Name shouldn't be valid");
    }

    @Before
    public void setUp() {
        this.elements = new ArrayList<CompetenceElement>();
        this.listeners = new ArrayList<DummyListener>();
        for (int i = 0; i < this.num; ++i) {
            CompetenceElement element = LapElementsFactory.createCompetenceElement((String)("e" + i), Arrays.asList(new Sense("t" + i)), (String)("a" + i));
            DummyListener listener = new DummyListener();
            this.listeners.add(listener);
            element.addElementListener((PoshElementListener)listener);
            this.elements.add(element);
        }
    }

    @Test
    public void testRemoveElement() throws Exception {
        System.out.println("removeElement");
        Competence instance = new Competence("testC", new FormalParameters(), this.elements);
        IElementMethod<Competence, CompetenceElement> removeMethod = new IElementMethod<Competence, CompetenceElement>(){

            @Override
            public void method(Competence element, CompetenceElement child) {
                element.removeElement(child);
            }
        };
        RemoveTest<Competence, CompetenceElement> test = new RemoveTest<Competence, CompetenceElement>(instance, this.elements, removeMethod, 1);
        test.runTest();
    }

    public static class DummyListener
    implements PoshElementListener {
        public PoshElement lastAddedChild;
        public PoshElement lastMovedChild;
        public Integer lastMovedNewPosition;
        public PoshElement lastRemovedChild;
        public PropertyChangeEvent lastPropertyChange;

        public void propertyChange(PropertyChangeEvent evt) {
            this.lastPropertyChange = evt;
        }

        public void childElementAdded(PoshElement parent, PoshElement child) {
            this.lastAddedChild = child;
        }

        public void childElementMoved(PoshElement parent, PoshElement child, int oldIndex, int newIndex) {
            this.lastMovedChild = child;
            this.lastMovedNewPosition = newIndex;
        }

        public void childElementRemoved(PoshElement parent, PoshElement child, int removedChildIndex) {
            this.lastRemovedChild = child;
        }
    }
}

