/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceTest;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.IElementMethod;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.RemoveTest;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActionPatternTest {
    private List<TriggeredAction> actions;
    private ActionPattern instance;
    private int num = 10;
    private String prefix = "action-";
    private String apName = "testAP";

    private void init() throws CycleException {
        this.actions = new LinkedList<TriggeredAction>();
        for (int i = 0; i < this.num; ++i) {
            this.actions.add(LapElementsFactory.createAction((String)(this.prefix + i)));
        }
        this.instance = LapElementsFactory.createActionPattern((String)this.apName, (FormalParameters)new FormalParameters(), this.actions);
    }

    @Before
    public void setUp() throws CycleException {
        this.init();
    }

    @Test
    public void testAddAction() throws Exception {
        System.out.println("addAction");
        TriggeredAction action = LapElementsFactory.createAction((String)"testAction");
        this.instance.addAction(action);
        Assert.assertTrue((boolean)this.instance.getActions().contains(action));
        Assert.assertTrue((this.instance.getActions().size() == this.num + 1 ? 1 : 0) != 0);
        for (int i = 0; i < this.num; ++i) {
            TriggeredAction sameNameAction = LapElementsFactory.createAction((String)(this.prefix + i));
            Assert.assertFalse((boolean)this.instance.getActions().contains(sameNameAction));
            this.instance.addAction(sameNameAction);
            Assert.assertTrue((boolean)this.instance.getActions().contains(sameNameAction));
            Assert.assertTrue((this.instance.getActions().size() == this.num + 2 + i ? 1 : 0) != 0);
        }
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        this.instance = LapElementsFactory.createActionPattern((String)this.apName, (FormalParameters)new FormalParameters(), Arrays.asList(LapElementsFactory.createAction((String)"love"), LapElementsFactory.createAction((String)"peace"), LapElementsFactory.createAction((String)"empathy")));
        String expResult = "(AP testAP (love peace empathy))";
        String result = this.instance.toString().replaceAll("\\s+", " ").trim();
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testSetName() throws Exception {
        System.out.println("setName");
        String name = "testSetName";
        String oldName = this.instance.getName();
        CompetenceTest.DummyListener l = new CompetenceTest.DummyListener();
        this.instance.addElementListener((PoshElementListener)l);
        this.instance.setName(name);
        Assert.assertEquals((Object)name, (Object)this.instance.getName());
        Assert.assertEquals((Object)"apName", (Object)l.lastPropertyChange.getPropertyName());
        Assert.assertEquals((Object)oldName, (Object)l.lastPropertyChange.getOldValue());
        Assert.assertEquals((Object)name, (Object)l.lastPropertyChange.getNewValue());
    }

    @Test(expected=InvalidNameException.class)
    public void testSetNameInvalid() throws Exception {
        System.out.println("setName - invalid");
        String name = "123zlo";
        this.instance.setName(name);
    }

    @Test(expected=DuplicateNameException.class)
    public void testSetNameDuplicateAP() throws Exception {
        System.out.println("setName - duplicate AP");
        PoshPlan plan = LapElementsFactory.createPlan();
        plan.addActionPattern(this.instance);
        ActionPattern o = LapElementsFactory.createActionPattern((String)"otherAP", (FormalParameters)new FormalParameters());
        plan.addActionPattern(o);
        this.instance.setName(o.getName());
    }

    @Test(expected=DuplicateNameException.class)
    public void testSetNameDuplicateC() throws Exception {
        System.out.println("setName - duplicate C");
        PoshPlan plan = LapElementsFactory.createPlan();
        plan.addActionPattern(this.instance);
        Competence o = new Competence("otherAP", new FormalParameters(), Collections.emptyList());
        plan.addCompetence(o);
        this.instance.setName(o.getName());
    }

    @Test
    public void testRemoveAction() throws Exception {
        System.out.println("removeAction");
        IElementMethod<ActionPattern, TriggeredAction> action = new IElementMethod<ActionPattern, TriggeredAction>(){

            @Override
            public void method(ActionPattern element, TriggeredAction child) {
                element.removeAction(child);
            }
        };
        RemoveTest<ActionPattern, TriggeredAction> test = new RemoveTest<ActionPattern, TriggeredAction>(this.instance, this.actions, action, 1);
        test.runTest();
    }

    @Test(expected=AssertionError.class)
    public void testNeutralizeMissingChild() {
        System.out.println("neutralizeChild - missing");
        this.instance.removeAction(LapElementsFactory.createAction((String)"MissingAction"));
    }

    @Test
    public void testGetActions() {
        System.out.println("getActions");
        List result = this.instance.getChildDataNodes();
        Assert.assertEquals((long)this.actions.size(), (long)result.size());
        for (int i = 0; i < this.actions.size(); ++i) {
            Assert.assertEquals((Object)this.actions.get(i), result.get(i));
        }
    }
}

