/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.SolTime;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class Competence
extends PoshDummyElement
implements Comparable<Competence> {
    private String _name;
    private SolTime _timeout;
    private Goal _goal;
    private List<CompetencePriorityElement> _elements;
    private String _comment;
    public static final String cnName = "cnName";
    public static final String cnTimeoutAmmount = "cnTimeoutAmmount";
    public static final String cnTimeoutUnits = "cnTimeoutUnits";
    public static final String cnComment = "cnComment";
    public static final DataFlavor dataFlavor = new DataFlavor(Competence.class, "competence-node");
    protected FormalParameters parameters = new FormalParameters();

    public Competence(String name, SolTime solTime, Goal goal, List<CompetencePriorityElement> elementList, String comment) {
        this._name = name;
        this._timeout = solTime;
        this._goal = goal;
        this._elements = elementList;
        this._comment = comment;
        if (this._goal != null) {
            this._goal.setParent(this);
        }
        for (CompetencePriorityElement priorityElement : elementList) {
            priorityElement.setParent(this);
        }
    }

    public void addCompetencePriorityElement(CompetencePriorityElement competenceElement) {
        competenceElement.setParent(this);
        this._elements.add(competenceElement);
        this.emitChildNode(competenceElement);
    }

    public void setGoalNode(Goal goal) {
        goal.setParent(this);
        if (this._goal != null) {
            this._goal.remove();
        }
        this._goal = goal;
        this.emitChildNode(goal);
    }

    public Goal getGoal() {
        return this._goal;
    }

    public String toString() {
        String ret = "\t(C " + this._name;
        if (this._timeout != null) {
            ret = ret + " " + this._timeout.toString();
        }
        if (this._goal != null) {
            ret = ret + " " + this._goal.toString();
        }
        ret = ret + "\n\t\t(elements";
        for (CompetencePriorityElement element : this._elements) {
            ret = ret + "\n\t\t\t(" + element.toString() + ")";
        }
        return ret + "\n\t\t)\n\t)";
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>(this._elements);
        if (this._goal != null) {
            children.add(0, this._goal);
        }
        return children;
    }

    public List<CompetencePriorityElement> getPriorityElements() {
        return Collections.unmodifiableList(this._elements);
    }

    public LinkedList<CompetenceElement> getElements() {
        LinkedList<CompetenceElement> elementsList = new LinkedList<CompetenceElement>();
        for (CompetencePriorityElement priorityElement : this.getPriorityElements()) {
            for (CompetenceElement element : priorityElement.getElements()) {
                elementsList.add(element);
            }
        }
        return elementsList;
    }

    public void setNodeComment(String comment) {
        if (!comment.contains("\"")) {
            this._comment = comment;
            this.firePropertyChange(cnComment, null, comment);
        }
    }

    public String getNodeComment() {
        return this._comment;
    }

    public Double getNodeTimeoutAmmount() {
        return this._timeout.getCount();
    }

    public void setNodeTimeoutAmmount(Double a) {
        if (a != null) {
            this._timeout.setCount(a);
            this.firePropertyChange(cnTimeoutAmmount, null, a);
        }
    }

    public Integer getNodeTimeoutUnits() {
        return this._timeout.getUnits().getId();
    }

    public void setNodeTimeoutUnits(Integer newUnitsId) {
        if (newUnitsId != null) {
            for (SolTime.TimeUnits unit : SolTime.TimeUnits.values()) {
                if (unit.getId() != newUnitsId.intValue()) continue;
                this._timeout.setUnits(unit);
                this.firePropertyChange(cnTimeoutUnits, null, (Object)unit);
            }
        }
    }

    public void setNodeName(String name) throws ParseException {
        if ((name = name.trim()).matches("[_a-zA-Z][_\\-a-zA-Z0-9]*")) {
            if (!this.getNodeName().equals(name) && this.getRootNode() != null && !this.getRootNode().isUniqueAPorComp(name)) {
                String msg = "New name for competence '" + this._name + "'(" + name + ") is not unique for reaction plan.";
                JOptionPane.showMessageDialog(null, msg, "Duplicate name", 0);
                return;
            }
            String oldName = this._name;
            this._name = name;
            if (this.getRootNode() != null && this.getRootNode().isCycled()) {
                this._name = oldName;
                String msg = "New name (" + name + ") for competence '" + this.getNodeName() + "' is causing cycle.";
                JOptionPane.showMessageDialog(null, msg, "Cycle detected", 0);
                return;
            }
            this.firePropertyChange(cnName, null, name);
        }
    }

    public String getNodeName() {
        return this._name;
    }

    @Override
    public String getDisplayName() {
        return this.getNodeName();
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return this.moveNodeInList(this._elements, child, relativePosition);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        if (newChild instanceof Goal) {
            this.setGoalNode((Goal)newChild);
        } else if (newChild instanceof CompetencePriorityElement) {
            this.addCompetencePriorityElement((CompetencePriorityElement)newChild);
        } else {
            throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
        }
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (childNode == this._goal) {
            this.setGoalNode(new Goal(new Sense("fail")));
        } else if (this._elements.contains(childNode)) {
            if (this._elements.size() <= 1) {
                this.addCompetencePriorityElement(new CompetencePriorityElement(new CompetenceElement("competence element", new Sense("fail"), "do_nothing", null)));
            }
            this._elements.remove(childNode);
            childNode.remove();
        }
    }

    @Override
    public int compareTo(Competence o) {
        return this.toString().compareTo(o.toString());
    }

    protected void setParameters(FormalParameters parameters) {
        this.parameters = new FormalParameters(parameters);
    }

    public FormalParameters getParameters() {
        return this.parameters;
    }
}

