/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.UnexpectedElementException;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptCE2CE;
import cz.cuni.pogamut.posh.widget.accept.AcceptSense2CE;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.kidview.NamedBasicWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleSenseWidget;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class SimpleCompetenceElementWidget
extends NamedBasicWidget<CompetenceElement> {
    public SimpleCompetenceElementWidget(PoshScene poshScene, CompetenceElement dataNode, PoshWidget<? extends PoshElement> parent) {
        super(poshScene, dataNode, parent);
        this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new CompetenceElementInplaceEditor(dataNode)));
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.COMPETENCE_ELEMENT;
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();
        list.add(new AbstractMenuAction<CompetenceElement>("Add trigger sense", (CompetenceElement)this.getDataNode(), (PoshWidget)this){

            @Override
            public void actionPerformed(ActionEvent e) {
                String senseName = this.getIdentifierFromDialog("Name of new trigger");
                if (senseName != null) {
                    ((CompetenceElement)this.dataNode).addTriggerAct(LapElementsFactory.createSense((String)senseName));
                }
            }
        });
        int numEl = ((CompetenceElement)this.getDataNode()).getParent().getNumberOfChildInstances(CompetenceElement.class);
        if (numEl > 1) {
            list.add(new DeleteNodeAction("Delete choice", this.getDataNode()));
        }
        return list;
    }

    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (dataNode instanceof Sense) {
            SimpleSenseWidget poshSenseWidget = new SimpleSenseWidget(this.getPoshScene(), (Sense)dataNode, (PoshWidget<? extends PoshElement>)this);
            int index = 0;
            for (PoshWidget<PoshElement> pw : this.getChildNodes()) {
                if (!(pw instanceof SimpleSenseWidget)) break;
                ++index;
            }
            this.getChildNodes().add(0, poshSenseWidget);
            this.getPoshScene().addPoshWidget(poshSenseWidget, true);
        } else if (dataNode instanceof TriggeredAction) {
            this.addTriggeredActionWidgets((TriggeredAction)dataNode);
        } else {
            throw new UnexpectedElementException("Not expecting " + dataNode.getClass().getSimpleName());
        }
    }

    @Override
    public void elementPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("caName")) {
            this.setHeadlineText((String)evt.getNewValue());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        LinkedList<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();
        list.add(new AcceptCE2CE((CompetenceElement)this.getDataNode()));
        list.add(new AcceptSense2CE((CompetenceElement)this.getDataNode()));
        return list;
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        try {
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection(this.getDataNode(), String.class, "getName", "setName");
            nameProp.setName("caName");
            nameProp.setDisplayName("Name of competence atom");
            PropertySupport.Reflection retriesProp = new PropertySupport.Reflection(this.getDataNode(), Integer.class, "getRetries", "setRetries");
            retriesProp.setName("caRetries");
            retriesProp.setDisplayName("Number of retries");
            PropertySupport.Reflection commentProp = new PropertySupport.Reflection(this.getDataNode(), String.class, "getComment", "setComment");
            commentProp.setName("caComment");
            commentProp.setDisplayName("Comment");
            set.put(new Node.Property[]{nameProp, retriesProp, commentProp});
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    private static class CompetenceElementInplaceEditor
    implements TextFieldInplaceEditor {
        private CompetenceElement ce;

        private CompetenceElementInplaceEditor(CompetenceElement ce) {
            this.ce = ce;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.ce.getName();
        }

        public void setText(Widget widget, String newCEName) {
            this.ce.setName(newCEName);
        }
    }
}

