/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.kidview.SimpleRoleActionPatternWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleRoleActionWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleRoleCompetenceWidget;
import java.awt.Point;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.widget.Widget;

public abstract class SimpleBasicWidget<T extends PoshElement>
extends PoshWidget<T> {
    protected SimpleBasicWidget(PoshScene poshScene, T dataNode, PoshWidget<? extends PoshElement> parent, String name) {
        super(poshScene, dataNode, parent, name);
    }

    public final void nodeChanged(PoshTreeEvent event, PoshElement dataNode) {
        if (event == PoshTreeEvent.NEW_CHILD_NODE) {
            assert (this.getPoshScene().isInMainLayer(this));
            this.addChildWidget(dataNode);
        } else if (event == PoshTreeEvent.NODE_DELETED) {
            this.deleteWidgetFromScene(dataNode);
        } else if (event == PoshTreeEvent.CHILD_NODE_MOVED) {
            this.moveChildWidget(dataNode);
        } else {
            throw new IllegalArgumentException("Argument (" + event + ") shouldn't exist.");
        }
        this.getPoshScene().consolidate();
        this.doRepaint();
        this.updateSources();
    }

    protected abstract void addChildWidget(PoshElement var1);

    protected void moveChildWidget(PoshElement movedChildDN) {
        List<PoshWidget<? extends PoshElement>> widgetChildren = this.getChildNodes();
        List nodeChildren = movedChildDN.getParent().getChildDataNodes();
        int movedDataNodeIndex = this.getIndexOfElement(nodeChildren, movedChildDN);
        PoshWidget dataNodeAssociatedWidget = this.getAssociatedWidget(widgetChildren, movedChildDN);
        int currentDataNodeWidgetIndex = this.getIndexOfElement(widgetChildren, (Object)dataNodeAssociatedWidget);
        this.moveChildWidgetNode(currentDataNodeWidgetIndex, movedDataNodeIndex);
    }

    protected void deleteWidgetFromScene(PoshElement dataNode) {
        this.deleteWidgetSubtree(this);
        this.getPoshScene().deletePoshWidget(this);
        this.getDataNode().removeElementListener((PoshElementListener)this);
        PoshPlan root = this.getDataNode().getRootNode();
        root.removeListenersFromTree((PoshElementListener)this);
        if (this.getParent() != null) {
            this.getParent().getChildNodes().remove((Object)this);
        }
    }

    private void deleteWidgetSubtree(PoshWidget<? extends PoshElement> widget) {
        for (PoshWidget<PoshElement> child : widget.getChildNodes()) {
            this.deleteWidgetSubtree(child);
            this.getPoshScene().deletePoshWidget(child);
            this.getDataNode().removeElementListener(child);
        }
        widget.getChildNodes().clear();
    }

    protected abstract List<AbstractMenuAction> createMenuActions();

    @Override
    public final JPopupMenu getPopupMenu(Widget arg0, Point arg1) {
        JPopupMenu menu = new JPopupMenu("Popup menu");
        List<AbstractMenuAction> actionList = this.createMenuActions();
        for (AbstractMenuAction action : actionList) {
            JMenuItem item = new JMenuItem(action.getDescription());
            item.addActionListener(action);
            menu.add(item);
        }
        return menu;
    }

    private Competence isComp(TriggeredAction ta) {
        String name = ta.getName();
        PoshPlan rootNode = ta.getRootNode();
        for (Competence competence : rootNode.getCompetences()) {
            if (!competence.getName().equals(name)) continue;
            return competence;
        }
        return null;
    }

    private ActionPattern isAP(TriggeredAction ta) {
        String name = ta.getName();
        PoshPlan rootNode = ta.getRootNode();
        for (ActionPattern ap : rootNode.getActionPatterns()) {
            if (!ap.getName().equals(name)) continue;
            return ap;
        }
        return null;
    }

    protected void addTriggeredActionWidgets(TriggeredAction dataNode) {
        int pos = this.getChildNodes().size();
        this.addTriggeredActionWidgets(pos, dataNode);
    }

    protected void addTriggeredActionWidgets(int index, TriggeredAction dataNode) {
        ActionPattern apNode = this.isAP(dataNode);
        if (apNode != null) {
            SimpleRoleActionPatternWidget actionRoleWidget = new SimpleRoleActionPatternWidget(this.getPoshScene(), dataNode, (PoshWidget<? extends PoshElement>)this, apNode);
            this.getChildNodes().add(index, actionRoleWidget);
            this.getPoshScene().addPoshWidget(actionRoleWidget, true);
            actionRoleWidget.regenerate();
        } else {
            Competence compNode = this.isComp(dataNode);
            if (compNode != null) {
                SimpleRoleCompetenceWidget competenceWidget = new SimpleRoleCompetenceWidget(this.getPoshScene(), dataNode, (PoshWidget<? extends PoshElement>)this, compNode);
                this.getChildNodes().add(index, competenceWidget);
                this.getPoshScene().addPoshWidget(competenceWidget, true);
                competenceWidget.regenerate();
            } else {
                SimpleRoleActionWidget actionRoleWidget = new SimpleRoleActionWidget(this.getPoshScene(), dataNode, (PoshWidget<? extends PoshElement>)this);
                this.getChildNodes().add(index, actionRoleWidget);
                this.getPoshScene().addPoshWidget(actionRoleWidget, true);
            }
        }
    }

    protected void changeTriggeredActionWidgets(TriggeredAction ta) {
        SimpleBasicWidget parent = (SimpleBasicWidget)this.getParent();
        int pos = 0;
        for (PoshWidget<PoshElement> child : parent.getChildNodes()) {
            if (child == this) {
                parent.addTriggeredActionWidgets(pos, ta);
                this.deleteWidgetFromScene((PoshElement)this.getDataNode());
                this.getPoshScene().consolidate();
                this.getScene().validate();
                break;
            }
            ++pos;
        }
    }

    protected final int getIndexOfElement(List list, Object element) {
        int position = 0;
        for (Object listElement : list) {
            if (listElement == element) {
                return position;
            }
            ++position;
        }
        throw new RuntimeException("Object " + element + " not found in list.");
    }

    protected final PoshWidget getAssociatedWidget(List<PoshWidget<? extends PoshElement>> list, PoshElement dataNode) {
        for (PoshWidget<? extends PoshElement> w : list) {
            if (w.getDataNode() != dataNode) continue;
            return w;
        }
        throw new RuntimeException("DataNode " + dataNode + " not found in list.");
    }

    protected final void moveChildWidgetNode(int from, int to) {
        PoshWidget<PoshElement> movingWidget = this.getChildNodes().get(from);
        this.getChildNodes().add(to, movingWidget);
        if (from > to) {
            ++from;
        }
        this.getChildNodes().remove(from);
    }
}

