/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.view;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import java.util.ArrayList;
import java.util.List;

public class TreeCollapseImprint {
    private CollapseStateNode root;

    public TreeCollapseImprint(PoshWidget<? extends PoshElement> dcw) {
        this.root = new CollapseStateNode(dcw);
    }

    public void restore(PoshWidget<? extends PoshElement> dcw) {
        this.root.restore(dcw);
    }

    private static class CollapseStateNode {
        private String nodeHeadline;
        private Class nodeClass;
        private boolean collapsed;
        private List<CollapseStateNode> children;

        private CollapseStateNode(PoshWidget<? extends PoshElement> widget) {
            this.nodeHeadline = widget.getHeadlineText();
            this.nodeClass = ((Object)widget).getClass();
            this.collapsed = widget.isCollapsed();
            this.children = new ArrayList<CollapseStateNode>();
            for (PoshWidget<PoshElement> child : widget.getChildNodes()) {
                this.children.add(new CollapseStateNode(child));
            }
        }

        public void restore(PoshWidget<? extends PoshElement> widget) {
            if (!this.sameInfo(widget)) {
                return;
            }
            for (CollapseStateNode childCollapseNode : this.children) {
                for (PoshWidget<PoshElement> childWidget : widget.getChildNodes()) {
                    if (!childCollapseNode.sameInfo(childWidget)) continue;
                    childCollapseNode.restore(childWidget);
                }
            }
            if (this.collapsed) {
                widget.setCollapsed(this.collapsed);
            }
        }

        private boolean sameInfo(PoshWidget widget) {
            return this.nodeHeadline != null && widget != null && this.nodeHeadline.equals(widget.getHeadlineText()) && this.nodeClass == ((Object)((Object)widget)).getClass();
        }
    }
}

