/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.pogamut.posh.explorer.Crawler;
import cz.cuni.pogamut.posh.explorer.CrawlerListener;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;

abstract class Explorer<T>
extends JPanel
implements CrawlerListener<T>,
ListCellRenderer {
    private final DocumentListener searchTextListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            Explorer.this.updateModel();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            Explorer.this.updateModel();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            Explorer.this.updateModel();
        }
    };
    private final ListSelectionListener selectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Explorer.this.selectedIndex = Explorer.this.resultList.getSelectedIndex();
        }
    };
    private final TransferHandler transferHandler = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (Explorer.this.selectedIndex != 0) {
                return Explorer.this.createItemTransferable(Explorer.this.getSelected());
            }
            return Explorer.this.newItemTransferable;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }
    };
    private final Transferable newItemTransferable;
    private final Set<T> cache = new HashSet<T>();
    private final Crawler<T> refreshCrawler;
    private int selectedIndex;
    private final DefaultListModel listModel = new DefaultListModel();
    private final Comparator<T> toStringComparator = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
        }
    };
    private final DefaultListCellRenderer listRenderer = new DefaultListCellRenderer();
    private static final Logger log = Logger.getLogger(Explorer.class.getSimpleName());
    private JButton btnNew;
    private JButton btnRefresh;
    private JCheckBox flgCaseSensitive;
    private JLabel lblLocation;
    private JLabel lblSearchTypeDescription;
    private JLabel lblStatesFound;
    private JScrollPane resultContainer;
    private JList resultList;
    private JTextField txtLocation;
    private JTextField txtPrefix;

    public Explorer(Crawler<T> refreshCrawler) {
        this.refreshCrawler = refreshCrawler;
        this.newItemTransferable = this.createNewItemTransferable();
        this.initComponents();
        this.resultList.setDragEnabled(true);
        this.resultList.setTransferHandler(this.transferHandler);
        this.resultList.setSelectionMode(0);
        this.resultList.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.resultList.setCellRenderer(this.listRenderer);
        this.updateModel();
        this.txtPrefix.getDocument().addDocumentListener(this.searchTextListener);
    }

    public T getSelected() {
        if (this.selectedIndex == 0) {
            return null;
        }
        return (T)this.listModel.get(this.selectedIndex);
    }

    protected abstract String getNewItemLabel();

    protected abstract boolean filter(String var1, boolean var2, T var3);

    protected abstract String getRenderedLabel(T var1);

    protected abstract String getItemDescription(T var1);

    protected abstract Transferable createItemTransferable(T var1);

    protected abstract Transferable createNewItemTransferable();

    protected abstract void displayItem(T var1);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String label;
        if (index == 0) {
            label = value.toString();
        } else {
            Object item = value;
            label = this.getRenderedLabel(item);
        }
        return this.listRenderer.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
    }

    private List<T> filterSet(Set<T> set, String expression, boolean caseSensitive) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : set) {
            if (this.filter(expression, caseSensitive, item)) continue;
            result.add(item);
        }
        return result;
    }

    private void updateModel() {
        List<T> result = this.filterSet(this.cache, this.txtPrefix.getText(), this.flgCaseSensitive.isSelected());
        Collections.sort(result, this.toStringComparator);
        this.setModel(this.listModel, result);
    }

    private void setModel(DefaultListModel model, List<T> list) {
        model.setSize(list.size() + 1);
        model.set(0, this.getNewItemLabel());
        for (int i = 0; i < list.size(); ++i) {
            model.set(i + 1, list.get(i));
        }
    }

    @Override
    public void started(Crawler<T> crawler) {
        assert (SwingUtilities.isEventDispatchThread());
        log.info("Started crawling, clear the cache " + this.cache.size() + " crawler " + crawler.getName());
        this.cache.clear();
        this.updateModel();
    }

    @Override
    public void crawledData(Crawler<T> crawler, Collection<T> data) {
        assert (SwingUtilities.isEventDispatchThread());
        log.info("Crawled data " + data.size());
        for (T item : data) {
            log.info("  * " + item);
        }
        this.cache.addAll(data);
        this.updateModel();
    }

    @Override
    public void finished(Crawler<T> crawler, boolean error) {
        assert (SwingUtilities.isEventDispatchThread());
        log.info("Finished crawling");
        crawler.removeListener(this);
    }

    private void initComponents() {
        this.lblSearchTypeDescription = new JLabel();
        this.txtPrefix = new JTextField();
        this.lblStatesFound = new JLabel();
        this.flgCaseSensitive = new JCheckBox();
        this.resultContainer = new JScrollPane();
        this.resultList = new JList(){

            @Override
            public String getToolTipText(MouseEvent e) {
                int index = this.locationToIndex(e.getPoint());
                if (index > 0) {
                    Object item = this.getModel().getElementAt(index);
                    return Explorer.this.getItemDescription(item);
                }
                return null;
            }
        };
        this.txtLocation = new JTextField();
        this.lblLocation = new JLabel();
        this.btnNew = new JButton();
        this.btnRefresh = new JButton();
        this.lblSearchTypeDescription.setText(NbBundle.getMessage(Explorer.class, (String)"Explorer.lblSearchTypeDescription.text"));
        this.txtPrefix.setFont(new Font("DialogInput", 0, 11));
        this.txtPrefix.setText(NbBundle.getMessage(Explorer.class, (String)"Explorer.txtPrefix.text"));
        this.txtPrefix.setBorder(BorderFactory.createEtchedBorder());
        this.lblStatesFound.setText(NbBundle.getMessage(Explorer.class, (String)"Explorer.lblStatesFound.text"));
        this.flgCaseSensitive.setText(NbBundle.getMessage(Explorer.class, (String)"Explorer.flgCaseSensitive.text"));
        this.flgCaseSensitive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Explorer.this.flgCaseSensitiveActionPerformed(evt);
            }
        });
        this.resultContainer.setBorder(BorderFactory.createEtchedBorder());
        this.resultList.setModel(this.listModel);
        this.resultList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Explorer.this.resultListMouseClicked(evt);
            }
        });
        this.resultContainer.setViewportView(this.resultList);
        this.txtLocation.setEditable(false);
        this.txtLocation.setText(NbBundle.getMessage(Explorer.class, (String)"Explorer.txtLocation.text"));
        this.lblLocation.setText(NbBundle.getMessage(Explorer.class, (String)"Explorer.lblLocation.text"));
        this.lblLocation.setVerticalAlignment(3);
        this.btnNew.setText(NbBundle.getMessage(Explorer.class, (String)"Explorer.btnNew.text"));
        this.btnRefresh.setText(NbBundle.getMessage(Explorer.class, (String)"Explorer.btnRefresh.text"));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Explorer.this.btnRefreshActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultContainer, GroupLayout.Alignment.TRAILING, -1, 283, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRefresh).addGap(18, 18, 18).addComponent(this.flgCaseSensitive)).addComponent(this.txtPrefix, -1, 283, Short.MAX_VALUE).addComponent(this.lblSearchTypeDescription).addComponent(this.txtLocation, -1, 283, Short.MAX_VALUE).addComponent(this.lblLocation).addComponent(this.lblStatesFound)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblSearchTypeDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPrefix, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNew).addComponent(this.btnRefresh).addComponent(this.flgCaseSensitive)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStatesFound, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultContainer, -1, 260, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtLocation, -2, -1, -2).addContainerGap()));
    }

    private void flgCaseSensitiveActionPerformed(ActionEvent evt) {
        this.updateModel();
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.refreshCrawler.addListener(this);
        this.refreshCrawler.crawl();
    }

    private void resultListMouseClicked(MouseEvent evt) {
        int index;
        if (evt.getClickCount() == 2 && (index = this.resultList.locationToIndex(evt.getPoint())) > 0) {
            this.displayItem(this.listModel.get(index));
        }
    }
}

