package cz.cuni.pogamut.posh.properties;

import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters.Parameter;
import cz.cuni.amis.pogamut.sposh.elements.Result;

/**
 * Visual editor for changing the formal parameter of the AP,C, and A&S.
 * Used by another {@link Inplace}, basically bloatware, sorry about that.
 *
 * @author Honza
 */
final class ParameterEditorPanel extends javax.swing.JPanel {

    /**
     * Create new editor for formal parameters, set the values accoring to intial
     * parameter.
     * @param initial parameter used to determine what should be initally shown
     */
    ParameterEditorPanel(Parameter initial) {
        initComponents();
        setParameter(initial);
    }

    /**
     * Get parameter according to values user has set in this editor.
     * @param parameter
     */
    public Parameter getParameter() {
        String name = txt_name.getText();
        String textValue = txt_value.getText();
        // TODO: check that parameters are in clear
        Object value = Result.parseValue(textValue);
        return new FormalParameters.Parameter(name, value);
    }

    /**
     * Set visual gadgets of this editor to reflect parameter.
     * @param parameter parameter whos values are to be used to set visual gadgets
     */
    public void setParameter(Parameter parameter) {
        String name = parameter.getName();
        Object value = parameter.getDefaultValue();
        txt_name.setText(name);
        txt_value.setText(value == null ? "nil" : value.toString());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lbl_name = new javax.swing.JLabel();
        lbl_value = new javax.swing.JLabel();
        txt_name = new javax.swing.JTextField();
        txt_value = new javax.swing.JTextField();

        lbl_name.setText(org.openide.util.NbBundle.getMessage(ParameterEditorPanel.class, "ParameterEditorPanel.lbl_name.text")); // NOI18N

        lbl_value.setText(org.openide.util.NbBundle.getMessage(ParameterEditorPanel.class, "ParameterEditorPanel.lbl_value.text")); // NOI18N

        txt_name.setText(org.openide.util.NbBundle.getMessage(ParameterEditorPanel.class, "ParameterEditorPanel.txt_name.text")); // NOI18N
        txt_name.setToolTipText(org.openide.util.NbBundle.getMessage(ParameterEditorPanel.class, "ParameterEditorPanel.txt_name.toolTipText")); // NOI18N

        txt_value.setText(org.openide.util.NbBundle.getMessage(ParameterEditorPanel.class, "ParameterEditorPanel.txt_value.text")); // NOI18N
        txt_value.setToolTipText(org.openide.util.NbBundle.getMessage(ParameterEditorPanel.class, "ParameterEditorPanel.txt_value.toolTipText")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lbl_name)
                        .addGap(56, 56, 56)
                        .addComponent(txt_name))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lbl_value)
                        .addGap(18, 18, 18)
                        .addComponent(txt_value, javax.swing.GroupLayout.PREFERRED_SIZE, 123, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbl_name)
                    .addComponent(txt_name, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbl_value)
                    .addComponent(txt_value, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lbl_name;
    private javax.swing.JLabel lbl_value;
    private javax.swing.JTextField txt_name;
    private javax.swing.JTextField txt_value;
    // End of variables declaration//GEN-END:variables
}
