package cz.cuni.pogamut.posh.widget.structure;

import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.menuactions.AddDE2DPE;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author Honza
 */
public class StrDriveWidget extends StrBasicWidget<DrivePriorityElement> {

	public StrDriveWidget(PoshScene poshScene, DrivePriorityElement dataNode, PoshWidget parent) {
		super(poshScene, dataNode, parent);
	}

	@Override
	protected List<AbstractMenuAction> createMenuActions() {
                LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();

                list.add(new AddDE2DPE(getDataNode()));

                if (getDataNode().getParent().getNumberOfChildInstances(getDataNode().getClass()) > 1) {
                    list.add(new DeleteNodeAction("Delete", getDataNode()));
                }

                return list;
	}

	@Override
	protected void addChildWidget(PoshElement dataNode) {
		synchronizeDataNodeWidgets(dataNode);
	}

	@Override
	protected List<AbstractAcceptAction> getAcceptProviders() {
		// todo: implement
		return new LinkedList<AbstractAcceptAction>();
	}

	@Override
	protected PoshNodeType getType() {
		return PoshNodeType.DRIVE_PRIORITY_ELEMENT;
	}

        @Override
	public void propertyChange(PropertyChangeEvent evt) {
		throw new IllegalStateException("Drive priority element doesn't have any property (passed '" + evt.getPropertyName() + "').");
	}
}
