package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 * When action pattern is dropped to triggered action, add action pattern
 * to the POSH plan (if it isn't already there) and change name of triggered action
 * to name of action pattern and expand it. Also make sure it won't create a cycle.
 *
 * @author Honza
 */
public class AcceptAP2TA extends AbstractAcceptAction<TriggeredAction> {

    public AcceptAP2TA(PoshElement dataNode) {
        super(ActionPattern.dataFlavor, dataNode);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        ActionPattern ap = (ActionPattern) tr.getTransferData(dataFlavor);
        if (ap == null) {
            return;
        }

        PoshPlan root = this.dataNode.getRootNode();
        if (!root.getActionPatterns().contains(ap)) {
            try {
                root.addActionPattern(ap);
            } catch (ParseException ex) {
                NotifyDescriptor.Message desc =
                        new NotifyDescriptor.Message(ex.getMessage());
                DialogDisplayer.getDefault().notify(desc);
                return;
            }
        }

        this.dataNode.setActionName(ap.getNodeName());
    }
}

