package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

/**
 * Common predecesor for nodes that represent some element in posh
 * plan (drive, sense, AP...).
 * <ul>
 *  <li>SenseNode</li>
 *  <li>CompNode</li>
 *  <li>APNode</li>
 *  <li>ActionNode</li>
 * </ul>
 *
 * @author Honza
 */
abstract class AbstractPoshPaletteNode extends PoshPaletteNode {
	/**
	 * Create a LEAF node.
	 * @param children
	 */
	AbstractPoshPaletteNode() {
		super(Children.LEAF);
	}

	/**
	 * Create a LEAF node with passed lookup.
	 * @param lookup
	 */
	AbstractPoshPaletteNode(Lookup lookup) {
		super(Children.LEAF, lookup);
	}


	/**
	 * Create a transferable that has one data flavor and encapsulated data
	 * is associated posh data node.
	 * 
	 * @return DataNodeExTransferable made from associated PoshElement
	 */
	@Override
	final protected ExTransferable.Single createTransferable() {
		return new DataNodeExTransferable(this.getPoshDataNode());
	}

	/**
	 * Get a PoshElement that is associated with this node.
	 * @return associated PoshElement
	 */
	protected abstract PoshElement getPoshDataNode();
}
