/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptAP2TA;
import cz.cuni.pogamut.posh.widget.accept.AcceptComp2TA;
import cz.cuni.pogamut.posh.widget.accept.AcceptTA2TA;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.kidview.SimpleBasicWidget;
import cz.cuni.pogamut.posh.widget.menuactions.AddTA2AP;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class SimpleRoleActionPatternWidget
extends SimpleBasicWidget {
    ActionPattern apNode;

    public SimpleRoleActionPatternWidget(PoshScene poshScene, TriggeredAction dataNode, PoshWidget parent, ActionPattern apNode) {
        super(poshScene, dataNode, parent);
        this.apNode = apNode;
        this.apNode.addPoshTreeChangeListener((PoshElementListener)this);
        this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new APInplaceEditor(dataNode, apNode)));
    }

    @Override
    protected PoshWidget.PropertyNode createPropertiesNode() {
        return new PoshWidget.PropertyNode((PoshElement)this.apNode, this);
    }

    public void regenerate() {
        this.deleteChildrenWidgets();
        this.createCh();
    }

    private void deleteChildrenWidgets() {
        LinkedList children = this.getChildNodes();
        if (children == null) {
            children = new LinkedList();
        }
        for (PoshWidget widget : children) {
            this.getPoshScene().deletePoshWidget(widget);
        }
    }

    private void createCh() {
        LinkedList<PoshWidget> fringe = new LinkedList<PoshWidget>(this.createWidgetChildren(this, (PoshElement)this.apNode));
        while (!fringe.isEmpty()) {
            PoshWidget headWidget = (PoshWidget)((Object)fringe.poll());
            Object headDataNode = headWidget.getDataNode();
            if (headDataNode instanceof TriggeredAction) continue;
            fringe.addAll(this.createWidgetChildren(headWidget, (PoshElement)headDataNode));
        }
    }

    private List<PoshWidget> createWidgetChildren(PoshWidget w, PoshElement dn) {
        List dataChildren = dn.getChildDataNodes();
        for (PoshElement dnch : dataChildren) {
            w.nodeChanged(PoshTreeEvent.NEW_CHILD_NODE, dnch);
        }
        return w.getChildNodes();
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.ACTION_PATTERN;
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();
        list.add(new AddTA2AP(this.apNode));
        int numTAs = this.getDataNode().getParent().getNumberOfChildInstances(TriggeredAction.class);
        if (numTAs > 1) {
            list.add(new DeleteNodeAction("Delete action", (PoshElement)this.getDataNode()));
        }
        return list;
    }

    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (!(dataNode instanceof TriggeredAction)) {
            throw new RuntimeException("Child of this type not permitted: " + dataNode.getClass().getName());
        }
        this.addTriggeredActionWidgets((TriggeredAction)dataNode);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("taName")) {
            this.changeTriggeredActionWidgets((TriggeredAction)this.getDataNode());
            this.doRepaint();
        }
        if (evt.getPropertyName().equals("apName")) {
            this.changeTriggeredActionWidgets((TriggeredAction)this.getDataNode());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        LinkedList<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();
        list.add(new AcceptTA2TA((PoshElement)this.getDataNode()));
        list.add(new AcceptAP2TA((PoshElement)this.getDataNode()));
        list.add(new AcceptComp2TA((TriggeredAction)this.getDataNode()));
        return list;
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        try {
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection((Object)this.apNode, String.class, "getNodeName", "setNodeName");
            PropertySupport.Reflection commentProp = new PropertySupport.Reflection((Object)this.apNode, String.class, "getNodeComment", "setNodeComment");
            nameProp.setName("apName");
            commentProp.setName("apComment");
            nameProp.setDisplayName("Name of action pattern");
            commentProp.setDisplayName("Comment about node");
            commentProp.setShortDescription("It is difficult to keep track about what part of POSH plan does what and that is where comments come in.");
            set.put(new Node.Property[]{nameProp, commentProp});
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    public static class ComboBoxProperty<T>
    extends PropertySupport.Reflection<Integer> {
        public ComboBoxProperty(T[] items, Class tClass, Object propertyObject, String getter, String setter) throws NoSuchMethodException {
            super(new Items((Object[])items, tClass, propertyObject, getter, setter), Integer.class, "getItemId", "setItemId");
            int[] intValues = new int[items.length];
            String[] stringKeys = new String[items.length];
            for (int i = 0; i < items.length; ++i) {
                intValues[i] = i;
                stringKeys[i] = items[i].toString();
            }
            this.setValue("intValues", intValues);
            this.setValue("stringKeys", stringKeys);
        }

        private static class Items<T> {
            private T[] items;
            private Class tClass;
            private Object propertyObject;
            private String getter;
            private String setter;

            private Items(T[] list, Class tClass, Object propertyObject, String getter, String setter) {
                this(list, 0, tClass, propertyObject, getter, setter);
            }

            private Items(T[] list, int selected, Class tClass, Object propertyObject, String getter, String setter) {
                this.items = Arrays.copyOf(list, list.length);
                this.propertyObject = propertyObject;
                this.getter = getter;
                this.setter = setter;
            }

            public Integer getItemId() throws Exception {
                T currentItem = this.getProperty();
                for (int i = 0; i < this.items.length; ++i) {
                    if (!this.items[i].equals(currentItem)) continue;
                    return i;
                }
                throw new IllegalStateException("Currently selected value is not in object.");
            }

            public void setItemId(Integer newItemId) throws Exception {
                if (newItemId == null) {
                    return;
                }
                if (newItemId >= this.items.length) {
                    return;
                }
                if (newItemId < 0) {
                    return;
                }
                this.setProperty(this.items[newItemId]);
            }

            private void setProperty(T newItem) throws Exception {
                this.propertyObject.getClass().getMethod(this.setter, this.tClass).invoke(this.propertyObject, newItem);
            }

            private T getProperty() throws Exception {
                return (T)this.propertyObject.getClass().getMethod(this.getter, new Class[0]).invoke(this.propertyObject, new Object[0]);
            }
        }
    }

    protected static class APInplaceEditor
    implements TextFieldInplaceEditor {
        private TriggeredAction action;
        private ActionPattern ap;

        protected APInplaceEditor(TriggeredAction action, ActionPattern ap) {
            this.action = action;
            this.ap = ap;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.action.getDisplayName();
        }

        public void setText(Widget widget, String string) {
            String apName = this.ap.getNodeName();
            String actionName = this.action.getActionName();
            try {
                this.ap.setNodeName(string);
                this.action.setActionName(string);
            }
            catch (Exception ex) {
                try {
                    this.action.setActionName(actionName);
                    this.ap.setNodeName(apName);
                }
                catch (Exception ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        }
    }
}

