/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptDrive2DC;
import cz.cuni.pogamut.posh.widget.accept.AcceptGoal2DC;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.kidview.SimpleBasicWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleDriveWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleGoalWidget;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class SimpleDriveCollectionWidget
extends SimpleBasicWidget<DriveCollection> {
    public SimpleDriveCollectionWidget(PoshScene scene, DriveCollection associatedDataNode, PoshWidget parent) {
        super(scene, associatedDataNode, parent);
        this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new DCInplaceEditor(associatedDataNode)));
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.DRIVE_COLLECTION_NODE;
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();
        list.add(new AbstractMenuAction<DriveCollection>("Add drive", this.getDataNode()){

            @Override
            public void actionPerformed(ActionEvent e) {
                String driveName = this.getIdentifierFromDialog("Name of the drive.");
                if (driveName == null) {
                    return;
                }
                DriveElement driveElement = new DriveElement(driveName, new Triggers(new Sense("succeed")), "doNothing", null);
                DrivePriorityElement drive = new DrivePriorityElement(driveElement);
                ((DriveCollection)this.dataNode).addDrivePriorityElement(drive);
            }
        });
        return list;
    }

    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (dataNode instanceof Goal) {
            SimpleGoalWidget goalWidget = new SimpleGoalWidget(this.getPoshScene(), (Goal)dataNode, (PoshWidget)this);
            this.getChildNodes().add(0, goalWidget);
            this.getPoshScene().addPoshWidget(goalWidget, true);
        } else if (dataNode instanceof DrivePriorityElement) {
            SimpleDriveWidget driveWidget = new SimpleDriveWidget(this.getPoshScene(), (DrivePriorityElement)dataNode, (PoshWidget)this);
            this.getChildNodes().add(driveWidget);
            this.getPoshScene().addPoshWidget(driveWidget, true);
        } else {
            throw new RuntimeException("Unexpected child class " + dataNode.getClass().getName());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dcName")) {
            this.setHeadlineText((String)evt.getNewValue());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        LinkedList<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();
        list.add(new AcceptDrive2DC((DriveCollection)this.getDataNode()));
        list.add(new AcceptGoal2DC((DriveCollection)this.getDataNode()));
        return list;
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        try {
            PropertySupport.Reflection collectionNameProp = new PropertySupport.Reflection(this.getDataNode(), String.class, "getDriveCollectionName", "setDriveCollectionName");
            collectionNameProp.setName("dcName");
            collectionNameProp.setDisplayName("Name of drive collection");
            set.put((Node.Property)collectionNameProp);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    private static class DCInplaceEditor
    implements TextFieldInplaceEditor {
        private DriveCollection dc;

        private DCInplaceEditor(DriveCollection dc) {
            this.dc = dc;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.dc.getDisplayName();
        }

        public void setText(Widget widget, String newDCName) {
            this.dc.setDriveCollectionName(newDCName);
        }
    }
}

