/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.palette.external;

import cz.cuni.pogamut.posh.PoshDataObject;
import cz.cuni.pogamut.posh.palette.PaletteRoot;
import cz.cuni.pogamut.posh.palette.external.ExternalBehaviourLoader;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.palette.PaletteController;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class ExternalBehaviour2PaletteTask
implements Runnable {
    private Lookup lookup;

    public ExternalBehaviour2PaletteTask(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public synchronized void run() {
        PaletteController paletteController = (PaletteController)this.lookup.lookup(PaletteController.class);
        if (paletteController == null) {
            throw new IllegalArgumentException("Lookup has no PaletteController.");
        }
        PoshDataObject dataObj = (PoshDataObject)((Object)this.lookup.lookup(PoshDataObject.class));
        if (dataObj == null) {
            return;
        }
        ExternalBehaviourLoader behaviourLoader = new ExternalBehaviourLoader((DataObject)dataObj);
        Map<Class, ExternalBehaviourLoader.BehaviourPrimitives> info = behaviourLoader.createBehaviourInfo();
        ExternalBehaviourLoader.BehaviourPrimitives unitedBehaviour = this.getUnion(info.values());
        this.testUniqueness(unitedBehaviour.getActions());
        this.testUniqueness(unitedBehaviour.getSenses());
        PaletteRoot pal = (PaletteRoot)((Object)paletteController.getRoot().lookup(PaletteRoot.class));
        pal.getActionsChildren().setExternalActions(unitedBehaviour.getActions());
        pal.getSensesChildren().setExternalSenses(unitedBehaviour.getSenses());
    }

    private ExternalBehaviourLoader.BehaviourPrimitives getUnion(Collection<ExternalBehaviourLoader.BehaviourPrimitives> set) {
        HashSet<Method> actions = new HashSet<Method>();
        for (ExternalBehaviourLoader.BehaviourPrimitives bp : set) {
            actions.addAll(bp.getActions());
        }
        HashSet<Method> senses = new HashSet<Method>();
        for (ExternalBehaviourLoader.BehaviourPrimitives bp : set) {
            senses.addAll(bp.getSenses());
        }
        return new ExternalBehaviourLoader.BehaviourPrimitives(actions, senses);
    }

    private void testUniqueness(List<Method> methods) {
        HashSet<String> names = new HashSet<String>();
        for (Method m : methods) {
            if (names.contains(m.getName())) {
                throw new IllegalArgumentException("Method " + m.getName() + " in class " + m.getDeclaringClass().getCanonicalName() + " has duplicate with same name.");
            }
            names.add(m.getName());
        }
    }
}

