/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.palette;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import cz.cuni.amis.pogamut.sposh.SPOSHAction;
import cz.cuni.amis.pogamut.sposh.SPOSHSense;
import cz.cuni.pogamut.posh.PoshDataObject;
import cz.cuni.pogamut.posh.palette.AbstractPoshPaletteNode;
import cz.cuni.pogamut.posh.palette.PaletteRoot;
import cz.cuni.pogamut.posh.palette.PoshPaletteNode;
import cz.cuni.pogamut.posh.palette.external.ExternalBehaviour2PaletteTask;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public class PoshPaletteFactory {
    public static PaletteController createPalette(Lookup lookup) {
        PaletteRoot paletteRoot = new PaletteRoot(lookup);
        paletteRoot.setName("Palette Root");
        return PaletteFactory.createPalette((Node)paletteRoot, (PaletteActions)new MyActions(lookup), null, (DragAndDropHandler)new MyDnDHandler());
    }

    private static class MyDnDHandler
    extends DragAndDropHandler {
        private MyDnDHandler() {
        }

        public void customize(ExTransferable exTransferable, Lookup lookup) {
            PoshPaletteNode node = (PoshPaletteNode)((Object)lookup.lookup(PoshPaletteNode.class));
            if (node != null) {
                final String name = node.getName();
                exTransferable.put(node.createTransferable());
                exTransferable.put(new ExTransferable.Single(DataFlavor.stringFlavor){

                    protected Object getData() throws IOException, UnsupportedFlavorException {
                        return "DnD_" + name;
                    }
                });
            }
        }
    }

    private static class MyActions
    extends PaletteActions {
        private final Lookup lookup;

        MyActions(Lookup lookup) {
            this.lookup = lookup;
        }

        public Action[] getImportActions() {
            return null;
        }

        public Action[] getCustomPaletteActions() {
            return new Action[]{new AbstractAction("Import external behaviour"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(new ExternalBehaviour2PaletteTask(MyActions.this.lookup)).start();
                }
            }, new Search4Behavior("Add stubs to behavior", this.lookup)};
        }

        public Action[] getCustomCategoryActions(Lookup lookup) {
            return null;
        }

        public Action[] getCustomItemActions(Lookup lookup) {
            AbstractPoshPaletteNode res = (AbstractPoshPaletteNode)((Object)lookup.lookup(AbstractPoshPaletteNode.class));
            if (res == null) {
                return null;
            }
            return res.getActions(false);
        }

        public Action getPreferredAction(Lookup lookup) {
            return null;
        }

        private static class Search4Behavior
        extends AbstractAction {
            private final Lookup lookup;

            Search4Behavior(String name, Lookup lookup) {
                super(name);
                this.lookup = lookup;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                PoshDataObject dataObj = (PoshDataObject)((Object)this.lookup.lookup(PoshDataObject.class));
                if (dataObj == null) {
                    StatusDisplayer.getDefault().setStatusText("Data object for this plan not found in the lookup.");
                    return;
                }
                Project project = FileOwnerQuery.getOwner((FileObject)dataObj.getPrimaryFile());
                if (project == null) {
                    StatusDisplayer.getDefault().setStatusText("File " + dataObj.getPrimaryFile().getNameExt() + " is not part of project.");
                    return;
                }
                Sources sources = ProjectUtils.getSources((Project)project);
                SourceGroup[] sgs = sources.getSourceGroups("java");
                LinkedList<FileObject> behaviorFiles = new LinkedList<FileObject>();
                for (SourceGroup sg : sgs) {
                    behaviorFiles.addAll(this.search4Behaviour(sg.getRootFolder()));
                }
                if (behaviorFiles.size() == 0) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Behavior class not found. The name of file with behavior class has to containt \"behavior\"", 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                if (behaviorFiles.size() > 1) {
                    StringBuilder sb = new StringBuilder("Multiple files that may contain Behavior were found.\nIn the future, selection dialog will be here. For now, just rename the ones you are not interested in.");
                    for (FileObject fo : behaviorFiles) {
                        sb.append('\n');
                        sb.append(fo.getNameExt());
                    }
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)sb.toString(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                FileObject potentialBehavior = (FileObject)behaviorFiles.get(0);
                JavaSource js = JavaSource.forFileObject((FileObject)potentialBehavior);
                String[] actions = this.getActions();
                String[] senses = this.getSenses();
                try {
                    PrimitiveStubAdder methodAdder = new PrimitiveStubAdder(potentialBehavior.getName(), senses, actions);
                    js.runModificationTask((Task)methodAdder).commit();
                }
                catch (IOException e) {
                    StatusDisplayer.getDefault().setStatusText(e.getMessage());
                    Logger.getLogger("global").log(Level.SEVERE, e.getMessage(), e);
                }
            }

            private String[] getSenses() {
                Node[] nodes;
                PaletteController pc = (PaletteController)this.lookup.lookup(PaletteController.class);
                PaletteRoot palRoot = (PaletteRoot)((Object)pc.getRoot().lookup(PaletteRoot.class));
                LinkedList<String> senses = new LinkedList<String>();
                for (Node node : nodes = palRoot.getSensesChildren().getNodes()) {
                    senses.add(node.getDisplayName().replace("!", ""));
                }
                return senses.toArray(new String[0]);
            }

            private String[] getActions() {
                Node[] nodes;
                PaletteController pc = (PaletteController)this.lookup.lookup(PaletteController.class);
                PaletteRoot palRoot = (PaletteRoot)((Object)pc.getRoot().lookup(PaletteRoot.class));
                LinkedList<String> actions = new LinkedList<String>();
                for (Node node : nodes = palRoot.getActionsChildren().getNodes()) {
                    actions.add(node.getDisplayName().replace("!", ""));
                }
                return actions.toArray(new String[0]);
            }

            List<FileObject> search4Behaviour(FileObject root) {
                LinkedList<FileObject> files = new LinkedList<FileObject>();
                Enumeration en = root.getChildren(true);
                while (en.hasMoreElements()) {
                    String lowerName;
                    FileObject fo = (FileObject)en.nextElement();
                    if (!fo.isData() || !"java".equalsIgnoreCase(fo.getExt()) || !(lowerName = fo.getName().toLowerCase()).contains("behavior") && !lowerName.contains("behaviour")) continue;
                    files.add(fo);
                }
                return files;
            }

            private static class PrimitiveStubAdder
            implements CancellableTask<WorkingCopy> {
                private String behaviorFileName;
                private Map<String, AnnotationFlags> primitives = new HashMap<String, AnnotationFlags>();

                PrimitiveStubAdder(String behaviorFileName, String[] senses, String[] actions) {
                    this.behaviorFileName = behaviorFileName;
                    for (String sense : senses) {
                        if (this.primitives.containsKey(sense)) continue;
                        this.primitives.put(sense, AnnotationFlags.createSense());
                    }
                    for (String action : actions) {
                        if (this.primitives.containsKey(action)) {
                            this.primitives.get((Object)action).action = true;
                            continue;
                        }
                        this.primitives.put(action, AnnotationFlags.createAction());
                    }
                }

                private ClassTree getBehaviorTree(CompilationUnitTree cu) {
                    ClassTree behaviorClass = null;
                    for (Tree tree : cu.getTypeDecls()) {
                        ClassTree cand;
                        if (tree.getKind() != Tree.Kind.CLASS || !this.behaviorFileName.equals((cand = (ClassTree)tree).getSimpleName().toString())) continue;
                        behaviorClass = cand;
                    }
                    return behaviorClass;
                }

                private boolean isAnnotatedBy(AnnotationTree at, String annotationType) {
                    if (at.getAnnotationType().getKind() == Tree.Kind.IDENTIFIER) {
                        IdentifierTree identifier = (IdentifierTree)at.getAnnotationType();
                        System.err.println("Name of annotation" + identifier.getName());
                    } else {
                        Logger.getLogger("global").log(Level.SEVERE, "Unknown annotation kind " + (Object)((Object)at.getAnnotationType().getKind()));
                    }
                    return false;
                }

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TreeMaker make = workingCopy.getTreeMaker();
                    CompilationUnitTree cuTree = workingCopy.getCompilationUnit();
                    ClassTree behaviorClass = this.getBehaviorTree(cuTree);
                    if (behaviorClass == null) {
                        StatusDisplayer.getDefault().setStatusText("Behavior class not found in file " + this.behaviorFileName);
                        return;
                    }
                    for (Tree tree : behaviorClass.getMembers()) {
                        MethodTree mt;
                        String methodName;
                        if (tree.getKind() != Tree.Kind.METHOD || !this.primitives.containsKey(methodName = (mt = (MethodTree)tree).getName().toString())) continue;
                        this.primitives.remove(methodName);
                    }
                    ClassTree newClassTree = behaviorClass;
                    for (Map.Entry<String, AnnotationFlags> af : this.primitives.entrySet()) {
                        if (!af.getValue().action && !af.getValue().sense) continue;
                        MethodTree newMethod = this.createMethodTree(make, af.getKey(), TypeKind.INT, af.getValue().action, af.getValue().sense);
                        newClassTree = make.addClassMember(newClassTree, (Tree)newMethod);
                    }
                    workingCopy.rewrite((Tree)behaviorClass, (Tree)newClassTree);
                }

                private MethodTree createMethodTree(TreeMaker make, String methodName, TypeKind returnType, boolean action, boolean sense) {
                    ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>(2);
                    if (action) {
                        annotations.add(make.Annotation((Tree)make.Identifier((CharSequence)SPOSHAction.class.getName()), Collections.EMPTY_LIST));
                    }
                    if (sense) {
                        annotations.add(make.Annotation((Tree)make.Identifier((CharSequence)SPOSHSense.class.getName()), Collections.EMPTY_LIST));
                    }
                    NewClassTree newClassTree = make.NewClass(null, Collections.EMPTY_LIST, (ExpressionTree)make.Identifier((CharSequence)"UnsupportedOperationException"), Collections.singletonList(make.Literal((Object)"Not supported yet.")), null);
                    ThrowTree defaultThrow = make.Throw((ExpressionTree)newClassTree);
                    return make.Method(make.Modifiers(Collections.singleton(Modifier.PUBLIC), annotations), (CharSequence)methodName, (Tree)make.PrimitiveType(returnType), Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, make.Block(Collections.singletonList(defaultThrow), false), null);
                }

                public void cancel() {
                }

                private static class AnnotationFlags {
                    public boolean sense;
                    public boolean action;

                    private AnnotationFlags() {
                    }

                    public static AnnotationFlags createSense() {
                        AnnotationFlags af = new AnnotationFlags();
                        af.sense = true;
                        return af;
                    }

                    public static AnnotationFlags createAction() {
                        AnnotationFlags af = new AnnotationFlags();
                        af.action = true;
                        return af;
                    }

                    public String toString() {
                        return "S:" + this.sense + " A:" + this.action;
                    }
                }
            }
        }
    }
}

